#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=323335 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 06:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 06:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 06:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 06:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 06:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 06:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 06:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 06:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 06:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 10:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 10:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 10:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 11:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 11:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 11:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 12:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 12:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 12:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 12:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 12:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 12:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 13:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 13:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 13:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 14:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 14:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 14:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 14:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 14:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 14:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 14:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 14:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 14:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 15:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 15:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 15:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 15:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 15:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 15:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 16:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 16:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 16:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 16:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 16:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 16:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 16:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 17:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 17:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 17:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 17:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 17:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 17:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 18:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 18:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 18:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 19:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 19:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 19:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 20:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 20:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 20:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297151, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-06-07 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 21:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 21:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 21:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 22:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 22:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 22:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 22:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 22:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 22:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 23:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 23:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 23:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297254, 'Database Backup [database_backup_2025-06-08-00-04-02-v3-1-6.zip]', '2025-06-08 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 00:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 00:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 00:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 01:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 01:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 01:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 02:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 02:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 02:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 03:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 03:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 03:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 04:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 04:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 04:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 04:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 04:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 04:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 04:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 04:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 04:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 04:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 04:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 04:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 05:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 05:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 05:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 06:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 06:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 06:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 07:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 07:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 07:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 08:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 08:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 08:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 09:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 09:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 09:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 11:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 11:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 11:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 11:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 11:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 11:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 12:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 12:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 12:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 13:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 13:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 13:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 14:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 14:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 14:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 16:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 16:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 16:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 16:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 16:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 16:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 17:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 17:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 17:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 18:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 18:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 18:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 18:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 18:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 18:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 19:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 19:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 19:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 19:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 19:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 19:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 20:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 20:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 20:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 20:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 20:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 20:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 20:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 20:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 20:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297939, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-06-08 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 22:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 22:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 22:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298039, 'Database Backup [database_backup_2025-06-09-00-02-02-v3-1-6.zip]', '2025-06-09 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 00:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 00:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 00:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 00:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 00:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 00:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 01:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 01:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 01:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 01:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 01:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 01:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 01:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 01:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 01:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 02:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 02:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 02:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 02:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 02:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 02:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 02:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 02:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 02:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 03:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 03:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 03:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 03:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 03:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 03:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 06:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 06:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 06:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 06:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 06:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 06:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 06:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 06:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 06:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 07:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 07:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 07:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 08:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 08:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 08:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 09:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 09:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 09:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 09:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 09:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 09:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 09:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 09:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 09:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 10:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 10:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 10:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 11:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 11:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 11:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 11:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 11:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 11:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 13:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 13:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 13:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 14:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 14:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 14:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 15:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 15:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 15:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 16:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 16:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 16:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 16:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 16:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 16:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 16:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 16:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 16:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 16:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 16:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 16:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 16:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 16:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 16:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 18:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 18:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 18:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 19:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 19:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 19:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 19:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 19:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 19:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 20:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 20:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 20:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 20:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 20:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 20:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298736, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-06-09 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298737, 'Invoice Status Updated [Invoice Number: INV-174/06/2025, From: Unpaid To: Overdue]', '2025-06-09 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298738, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Overdue Notice]', '2025-06-09 21:03:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 21:03:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 21:03:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 21:03:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 21:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 21:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 21:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 21:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 21:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 21:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 22:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 22:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 22:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 22:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 22:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 22:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 22:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 22:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 22:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 22:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 22:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 22:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 23:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 23:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 23:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 23:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 23:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 23:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 23:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 23:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 23:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 23:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 23:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 23:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298841, 'Database Backup [database_backup_2025-06-10-00-02-03-v3-1-6.zip]', '2025-06-10 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 00:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 00:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 00:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 00:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 00:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 00:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 00:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 00:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 00:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 00:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 00:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 00:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 01:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 01:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 01:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 01:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 01:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 01:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 02:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 02:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 02:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 03:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 03:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 03:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 04:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 04:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 04:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 04:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 04:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 04:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 05:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 05:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 05:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 06:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 06:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 06:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 06:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 06:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 06:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 07:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 07:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 07:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 07:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 07:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 07:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 07:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 07:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 07:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 08:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 08:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 08:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 08:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 08:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 08:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 08:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 08:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 08:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 08:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 08:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 08:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 09:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 09:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 09:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 09:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 09:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 09:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 09:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 09:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 09:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 09:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 09:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 09:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 10:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 10:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 10:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 10:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 10:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 10:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 10:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 10:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 10:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 10:15:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 10:15:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 10:15:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 10:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 10:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 10:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 10:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 10:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 10:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 10:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 10:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 10:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 10:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 10:43:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 10:43:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 10:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 10:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 10:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 10:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 10:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 10:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 11:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 11:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 11:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 11:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 11:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 11:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 11:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 11:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 11:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 11:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 11:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 11:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 11:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 11:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 11:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 11:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 11:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 11:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 11:47:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 11:47:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 11:47:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 11:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 11:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 11:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 12:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 12:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 12:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 12:20:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 12:20:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 12:20:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 12:31:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 12:31:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 12:31:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 12:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 12:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 12:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 12:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 12:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 12:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 12:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 12:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 12:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 13:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 13:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 13:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 13:09:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 13:09:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 13:09:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 13:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 13:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 13:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 13:25:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 13:25:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 13:25:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 13:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 13:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 13:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 13:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 13:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 13:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 13:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 13:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 13:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 13:52:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 13:52:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 13:52:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 13:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 13:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 13:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 14:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 14:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 14:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 14:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 14:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 14:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 14:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 14:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 14:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 14:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 14:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 14:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 14:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 14:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 14:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 15:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 15:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 15:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 15:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 15:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 15:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 15:19:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 15:19:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 15:19:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 15:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 15:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 15:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 15:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 15:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 15:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 15:35:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 15:35:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 15:35:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 15:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 15:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 15:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 15:51:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 15:51:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 15:51:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 16:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 16:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 16:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 16:12:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 16:12:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 16:12:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 16:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 16:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 16:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 16:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 16:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 16:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 16:33:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 16:33:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 16:33:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 16:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 16:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 16:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 16:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 16:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 16:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 16:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 16:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 16:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 17:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 17:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 17:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 17:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 17:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 17:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 17:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 17:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 17:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 17:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 17:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 17:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 17:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 17:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 17:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 17:43:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 17:43:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 17:43:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 18:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 18:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 18:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 18:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 18:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 18:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 18:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 18:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 18:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 18:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 18:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 18:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 18:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 18:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 18:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 18:33:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 18:33:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 18:33:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 18:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 18:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 18:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 18:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 18:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 18:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 18:55:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 18:55:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 18:55:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 19:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 19:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 19:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 19:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 19:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 19:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 19:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 19:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 19:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 19:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 19:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 19:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 19:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 19:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 19:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 19:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 19:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 19:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 19:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 19:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 19:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 19:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 19:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 19:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 19:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 19:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 19:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 19:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 19:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 19:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 20:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 20:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 20:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 20:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 20:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 20:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 20:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 20:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 20:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 20:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 20:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 20:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 20:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 20:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 20:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 20:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 20:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 20:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 20:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 20:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 20:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 20:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 20:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 20:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 20:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 20:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 20:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 20:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 20:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 20:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 20:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 20:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 20:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299541, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-06-10 21:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 21:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 21:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 21:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 21:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 21:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 21:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 21:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 21:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 21:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 21:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 21:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 21:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 21:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 21:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 21:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 21:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 21:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 21:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 21:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 21:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 21:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 21:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 21:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 21:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 22:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 22:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 22:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 22:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 22:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 22:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 22:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 22:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 22:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 22:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 22:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 22:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 22:37:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 22:37:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 22:37:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 22:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 22:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 22:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 22:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 22:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 22:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 23:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 23:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 23:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 23:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 23:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 23:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 23:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 23:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 23:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 23:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 23:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 23:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 23:33:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 23:33:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 23:33:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 23:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 23:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 23:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299647, 'Database Backup [database_backup_2025-06-11-00-02-04-v3-1-6.zip]', '2025-06-11 00:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 00:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 00:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 00:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 00:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 00:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 00:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 00:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 00:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 00:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 00:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 00:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 00:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 01:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 01:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 01:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 01:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 01:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 01:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 01:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 01:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 01:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 01:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 01:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 01:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 01:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 01:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 01:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 02:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 02:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 02:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 02:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 02:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 02:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 02:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 02:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 02:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 02:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 02:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 02:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 02:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 02:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 02:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 02:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 02:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 02:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 03:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 03:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 03:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 03:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 03:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 03:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 03:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 03:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 03:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 03:21:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 03:21:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 03:21:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 03:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 03:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 03:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 03:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 03:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 03:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 03:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 03:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 03:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 04:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 04:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 04:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 04:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 04:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 04:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 04:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 04:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 04:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 04:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 04:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 04:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 04:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 04:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 04:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 04:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 04:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 04:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 05:09:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 05:09:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 05:09:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 05:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 05:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 05:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 05:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 05:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 05:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 05:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 05:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 05:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 05:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 05:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 05:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 05:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 05:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 05:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 06:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 06:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 06:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 06:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 06:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 06:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 06:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 06:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 06:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 06:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 06:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 06:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 06:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 06:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 06:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 06:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 06:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 06:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 06:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 06:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 06:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 07:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 07:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 07:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 07:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 07:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 07:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 07:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 07:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 07:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 07:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 07:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 07:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 07:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 07:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 07:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 07:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 07:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 07:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 07:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 07:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 07:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 08:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 08:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 08:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 08:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 08:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 08:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 08:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 08:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 08:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 08:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 08:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 08:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 08:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 08:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 08:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 08:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 08:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 08:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 08:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 08:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 08:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 08:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 08:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 08:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 08:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 08:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 08:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 09:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 09:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 09:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 09:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 09:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 09:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 09:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 09:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 09:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 09:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 09:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 09:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 09:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 09:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 09:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 09:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 09:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 09:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 09:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 09:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 09:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 09:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 09:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 09:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 10:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 10:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 10:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 10:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 10:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 10:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 10:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 10:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 10:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 10:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 10:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 10:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 10:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 10:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 10:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 10:49:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 10:49:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 10:49:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 10:54:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 10:54:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 10:54:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 10:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 10:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 10:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 11:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 11:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 11:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 11:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 11:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 11:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 11:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 11:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 11:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 11:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 11:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 11:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 11:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 11:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 11:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 11:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 11:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 11:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 11:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 11:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 11:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 11:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 11:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 11:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 11:38:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 11:38:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 11:38:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 11:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 11:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 11:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 11:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 11:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 11:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 11:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 11:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 11:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 11:59:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 11:59:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 11:59:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 12:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 12:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 12:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 12:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 12:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 12:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 12:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 12:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 12:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 12:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 12:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 12:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 12:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 12:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 12:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 12:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 12:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 12:47:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 12:47:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 12:47:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 12:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 12:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 12:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 13:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 13:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 13:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 13:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 13:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 13:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 13:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 13:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 13:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 13:09:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 13:09:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 13:09:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 13:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 13:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 13:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 13:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 13:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 13:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 13:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 13:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 13:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 13:30:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 13:30:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 13:30:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 13:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 13:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 13:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 13:41:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 13:41:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 13:41:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 13:41:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 13:41:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 13:41:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 13:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 13:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 13:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 13:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 13:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 13:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 13:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 13:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 13:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 14:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 14:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 14:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 14:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 14:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 14:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 14:19:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 14:19:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 14:19:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 14:24:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 14:24:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 14:24:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 14:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 14:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 14:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 14:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 14:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 14:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 14:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 14:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 14:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 14:47:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 14:47:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 14:47:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 14:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 14:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 14:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 14:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 14:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 14:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 15:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 15:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 15:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 15:09:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 15:09:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 15:09:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 15:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 15:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 15:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 15:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 15:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 15:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 15:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 15:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 15:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 15:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 15:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 15:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 15:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 15:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 15:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 15:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 15:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 15:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 15:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 15:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 15:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 16:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 16:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 16:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 16:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 16:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 16:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 16:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 16:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 16:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 16:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 16:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 16:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 16:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 16:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 16:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 16:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 16:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 16:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 16:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 16:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 16:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 16:31:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 16:31:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 16:31:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 16:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 16:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 16:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 16:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 16:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 16:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 16:58:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 16:58:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 16:58:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 17:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 17:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 17:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 17:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 17:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 17:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 17:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 17:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 17:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 17:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 17:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 17:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 17:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 17:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 17:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 17:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 17:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 17:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 17:37:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 17:37:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 17:37:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 17:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 17:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 17:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 17:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 17:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 17:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 17:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 17:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 17:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 18:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 18:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 18:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 18:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 18:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 18:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 18:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 18:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 18:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 18:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 18:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 18:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 18:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 18:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 18:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 18:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 18:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 18:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 18:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 18:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 18:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 18:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 18:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 18:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 18:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 18:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 18:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 18:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 18:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 18:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 19:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 19:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 19:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 19:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 19:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 19:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 19:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 19:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 19:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 19:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 19:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 19:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 19:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 19:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 19:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 19:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 19:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 19:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 19:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 19:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 19:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 19:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 19:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 19:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 19:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 19:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 19:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 19:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 19:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 19:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 19:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 19:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 19:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 19:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 19:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 19:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 20:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 20:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 20:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 20:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 20:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 20:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 20:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 20:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 20:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 20:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 20:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 20:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 20:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 20:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 20:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 20:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 20:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 20:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 20:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 20:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 20:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 20:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 20:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 20:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 20:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 20:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 20:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 20:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 20:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 20:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300401, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-06-11 21:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 21:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 21:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 21:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 21:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 21:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 21:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 21:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 21:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 21:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 21:31:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 21:31:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 21:31:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 21:31:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 21:31:25', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 21:31:25', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 21:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 21:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 21:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 21:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 21:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 21:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 21:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 21:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 21:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 22:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 22:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 22:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 22:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 22:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 22:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 22:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 22:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 22:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 22:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 22:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 22:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 23:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 23:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 23:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 23:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 23:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 23:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 23:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 23:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 23:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 23:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 23:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 23:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 23:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 23:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 23:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 23:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 23:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 23:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 23:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 23:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 23:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300516, 'Database Backup [database_backup_2025-06-12-00-04-04-v3-1-6.zip]', '2025-06-12 00:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300517, 'Database Backup [database_backup_2025-06-12-00-04-04-v3-1-6.zip]', '2025-06-12 00:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 00:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 00:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 00:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 00:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 00:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 00:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 00:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 00:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 00:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 00:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 00:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 00:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 00:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 00:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 00:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 00:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 00:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 00:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 00:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 00:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 00:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 00:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 00:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 00:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 00:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 00:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 00:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 00:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 00:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 00:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 01:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 01:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 01:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 13:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 13:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 13:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 13:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 13:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 13:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 13:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 13:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 13:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 13:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 13:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 13:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 13:47:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 13:47:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 13:47:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 13:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 13:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 13:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 13:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 13:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 13:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 14:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 14:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 14:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 14:09:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 14:09:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 14:09:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300584, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 14:09:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 14:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 14:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 14:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300588, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 14:15:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 14:21:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 14:21:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 14:21:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300592, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 14:21:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 14:27:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 14:27:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 14:27:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300596, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 14:27:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 14:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 14:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 14:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300600, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 14:32:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 14:38:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 14:38:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 14:38:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300604, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 14:38:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 14:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 14:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 14:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300608, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 14:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 14:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 14:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 14:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300612, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 14:49:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300613, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:cbfd:996a:1289:9624:857e]', '2025-06-12 14:52:59', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 14:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 14:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 14:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300617, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 14:55:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 15:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 15:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 15:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300621, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 15:00:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 15:06:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 15:06:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 15:06:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300625, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 15:06:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 15:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 15:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 15:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300629, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 15:12:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 15:18:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 15:18:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 15:18:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300633, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 15:18:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 15:24:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 15:24:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 15:24:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300637, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 15:24:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 15:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 15:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 15:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300641, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 15:30:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 15:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 15:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 15:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300645, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 15:36:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 15:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 15:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 15:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300649, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 15:42:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 16:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 16:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 16:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300653, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 16:07:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 16:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 16:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 16:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300657, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 16:13:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 16:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 16:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 16:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300661, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 16:19:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 16:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 16:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 16:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300665, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 16:25:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 16:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 16:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 16:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300669, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 16:30:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 16:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 16:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 16:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300673, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 16:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 16:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 16:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 16:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300677, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 16:42:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 16:47:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 16:47:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 16:47:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300681, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 16:47:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 16:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 16:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 16:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300685, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 16:53:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 16:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 16:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 16:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300689, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 16:58:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 17:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 17:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 17:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300693, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 17:04:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 17:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 17:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 17:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300697, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 17:10:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 17:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 17:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 17:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300701, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 17:16:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 17:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 17:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 17:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300705, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 17:22:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 17:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 17:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 17:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300709, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 17:28:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 17:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 17:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 17:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300713, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 17:34:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 17:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 17:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 17:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300717, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 17:39:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 17:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 17:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 17:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300721, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 17:45:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 17:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 17:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 17:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300725, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 17:50:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 17:56:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 17:56:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 17:56:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300729, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 17:56:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300730, 'Invoice Status Updated [Invoice Number: INV-175/06/2025, From: Draft To: Unpaid]', '2025-06-12 17:58:37', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 18:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 18:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 18:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300734, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 18:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 18:07:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 18:07:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 18:07:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300738, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 18:07:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 18:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 18:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 18:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300742, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 18:13:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 18:18:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 18:18:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 18:18:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300746, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 18:18:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 18:24:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 18:24:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 18:24:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300750, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 18:24:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 18:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 18:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 18:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300754, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 18:30:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 18:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 18:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 18:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300758, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 18:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 18:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 18:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 18:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300762, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 18:42:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 18:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 18:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 18:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300766, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 18:48:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 18:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 18:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 18:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300770, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 18:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 19:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 19:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 19:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300774, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 19:00:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 19:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 19:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 19:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300778, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 19:05:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 19:11:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 19:11:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 19:11:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300782, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 19:11:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 19:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 19:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 19:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300786, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 19:17:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 19:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 19:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 19:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300790, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 19:22:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 19:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 19:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 19:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300794, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 19:28:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 19:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 19:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 19:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300798, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 19:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 19:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 19:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 19:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300802, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 19:40:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 19:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 19:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 19:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300806, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 19:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 19:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 19:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 19:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300810, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 19:52:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300811, 'Invoice Status Updated [Invoice Number: INV-175/06/2025, From: Unpaid To: Paid]', '2025-06-12 19:53:34', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300812, 'Payment Recorded [ID:127, Invoice Number: INV-175/06/2025, Total: $820.00]', '2025-06-12 19:53:34', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 19:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 19:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 19:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300816, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 19:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 20:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 20:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 20:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300820, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 20:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 20:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 20:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 20:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300824, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 20:10:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 20:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 20:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 20:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300828, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 20:16:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300832, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 20:22:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 20:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 20:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 20:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300836, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 20:27:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 20:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 20:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 20:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300840, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 20:33:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 20:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 20:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 20:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300844, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 20:39:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 20:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 20:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 20:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300848, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 20:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 20:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 20:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 20:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300852, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 20:50:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 20:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 20:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 20:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300856, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 20:56:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 21:01:34', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 21:01:34', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 21:01:34', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300860, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 21:01:40', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 21:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 21:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 21:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300864, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 21:07:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 21:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 21:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 21:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300868, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 21:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300872, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 21:18:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300876, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 21:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 21:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 21:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 21:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300880, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 21:30:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 21:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 21:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 21:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300884, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 21:36:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 21:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 21:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 21:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300888, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 21:42:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300892, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 21:48:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 21:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 21:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 21:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300896, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 21:53:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300900, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 21:59:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 22:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 22:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 22:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300904, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 22:05:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300908, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 22:11:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 22:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 22:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 22:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300912, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 22:16:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300916, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 22:22:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 22:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 22:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 22:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300920, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 22:27:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 22:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 22:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 22:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300924, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 22:32:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300928, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 22:38:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 22:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 22:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 22:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300932, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 22:43:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 22:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 22:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 22:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300936, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 22:48:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 22:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 22:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 22:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300940, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 22:54:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 23:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 23:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 23:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300944, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 23:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 23:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 23:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 23:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300948, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 23:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 23:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 23:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 23:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300952, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 23:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 23:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 23:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 23:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300956, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 23:18:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 23:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 23:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 23:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300960, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 23:23:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300964, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 23:29:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 23:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 23:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 23:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300968, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 23:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 23:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 23:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 23:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300972, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 23:40:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 23:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 23:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 23:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300976, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 23:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 23:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 23:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 23:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300980, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 23:52:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 23:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 23:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 23:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300984, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 23:58:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300988, 'Database Backup [database_backup_2025-06-13-00-04-04-v3-1-6.zip]', '2025-06-13 00:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300989, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 00:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 00:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 00:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 00:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300993, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 00:10:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 00:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 00:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 00:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300997, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 00:16:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 00:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 00:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 00:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301001, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 00:22:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 00:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 00:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 00:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301005, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 00:27:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 00:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 00:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 00:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301009, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 00:33:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 00:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 00:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 00:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301013, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 00:39:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301017, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 00:45:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 00:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 00:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 00:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301021, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 00:50:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 00:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 00:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 00:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301025, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 00:56:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301029, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 01:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 01:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 01:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 01:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301033, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 01:08:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 01:13:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 01:13:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 01:13:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301037, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 01:13:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 01:19:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 01:19:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06