#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=311583 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 04:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 04:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 04:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 04:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 04:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 04:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 04:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 04:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 04:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 05:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 05:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 05:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 05:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 05:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 05:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 06:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 06:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 06:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 06:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 06:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 06:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 06:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 06:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 06:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 06:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 06:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 06:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 07:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 07:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 07:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 07:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 07:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 07:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 08:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 08:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 08:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 09:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 09:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 09:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 09:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 09:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 09:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 09:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 09:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 09:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 10:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 10:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 10:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 10:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 10:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 10:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 10:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 10:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 10:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 11:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 11:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 11:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 11:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 11:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 11:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 11:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 11:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 11:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 12:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 12:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 12:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 13:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 13:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 13:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 13:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 13:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 13:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 14:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 14:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 14:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 14:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 14:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 14:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 14:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 14:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 14:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 14:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 14:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 14:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 14:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 14:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 14:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 15:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 15:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 15:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 15:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 15:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 15:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 15:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 15:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 15:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 15:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 15:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 15:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 16:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 16:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 16:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 16:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 16:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 16:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 16:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 16:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 16:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 17:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 17:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 17:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 17:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 17:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 17:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 17:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 17:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 17:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 17:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 17:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 17:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 18:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 18:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 18:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 18:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 18:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 18:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 19:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 19:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 19:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 19:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 19:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 19:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 19:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 19:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 19:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 19:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 19:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 19:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 19:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 19:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 19:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 20:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 20:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 20:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 20:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 20:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 20:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 20:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 20:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 20:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 20:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 20:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 20:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 20:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 20:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 20:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 20:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 20:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 20:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286765, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-05-25 21:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286766, 'Email Sent To [Email: projenbeauty@yahoo.com, Template: Invoice Overdue Notice]', '2025-05-25 21:00:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286767, 'Email Sent To [Email: rabiansutherland@gmail.com, Template: Invoice Overdue Notice]', '2025-05-25 21:00:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 21:00:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 21:00:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 21:00:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 21:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 21:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 21:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 21:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 21:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 21:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 22:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 22:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 22:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 22:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 22:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 22:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 22:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 22:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 22:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 23:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 23:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 23:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 23:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 23:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 23:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-25 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-25 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-25 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286873, 'Database Backup [database_backup_2025-05-26-00-03-04-v3-1-6.zip]', '2025-05-26 00:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 00:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 00:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 00:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 00:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 00:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 00:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 00:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 00:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 00:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 00:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 00:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 00:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 00:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 00:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 00:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 01:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 01:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 01:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 01:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 01:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 01:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 01:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 01:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 01:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 02:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 02:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 02:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 02:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 02:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 02:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 02:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 02:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 02:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 03:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 03:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 03:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 03:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 03:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 03:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 03:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 03:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 03:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 03:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 03:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 03:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 03:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 03:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 03:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 03:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 03:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 03:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 04:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 04:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 04:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 04:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 04:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 04:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 04:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 04:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 04:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 05:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 05:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 05:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 05:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 05:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 05:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 06:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 06:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 06:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 06:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 06:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 06:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 06:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 06:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 06:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 07:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 07:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 07:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 07:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 07:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 07:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 07:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 07:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 07:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 08:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 08:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 08:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 08:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 08:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 08:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 08:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 08:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 08:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 09:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 09:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 09:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 10:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 10:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 10:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 10:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 10:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 10:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 10:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 10:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 10:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 10:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 10:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 10:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 11:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 11:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 11:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 12:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 12:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 12:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 12:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 12:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 12:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 12:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 12:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 12:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 12:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 12:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 12:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 13:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 13:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 13:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 13:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 13:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 13:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 13:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 13:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 13:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 14:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 14:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 14:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 14:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 14:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 14:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 14:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 14:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 14:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 15:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 15:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 15:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 16:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 16:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 16:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 16:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 16:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 16:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 16:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 16:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 16:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 16:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 16:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 16:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 17:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 17:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 17:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 17:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 17:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 17:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 17:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 17:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 17:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 17:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 17:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 17:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 18:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 18:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 18:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 18:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 18:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 18:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 18:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 18:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 18:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 18:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 18:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 18:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 19:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 19:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 19:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 19:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 19:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 19:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 19:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 19:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 19:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 19:32:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 19:32:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 19:32:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 19:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 19:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 19:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 19:43:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 19:43:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 19:43:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 19:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 19:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 19:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 19:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 19:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 19:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 20:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 20:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 20:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 20:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 20:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 20:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 20:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 20:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 20:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287564, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-05-26 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 21:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 21:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 21:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 21:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 21:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 21:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 22:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 22:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 22:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 22:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 22:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 22:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 23:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 23:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 23:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-26 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-26 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-26 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287667, 'Database Backup [database_backup_2025-05-27-00-01-04-v3-1-6.zip]', '2025-05-27 00:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 00:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 00:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 00:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 00:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 00:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 00:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 00:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 00:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 00:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 00:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 00:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 00:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 01:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 01:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 01:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 01:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 01:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 01:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 01:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 01:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 01:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 01:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 01:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 01:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 02:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 02:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 02:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 02:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 02:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 02:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 02:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 02:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 02:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 02:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 02:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 02:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 03:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 03:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 03:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 03:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 03:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 03:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 03:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 03:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 03:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 03:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 03:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 03:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 03:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 03:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 03:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 03:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 03:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 03:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 04:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 04:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 04:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 04:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 04:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 04:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 05:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 05:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 05:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 05:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 05:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 05:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 05:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 05:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 05:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 06:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 06:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 06:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 06:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 06:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 06:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 06:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 06:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 06:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 06:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 06:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 06:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 07:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 07:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 07:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 07:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 07:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 07:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 07:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 07:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 07:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 08:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 08:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 08:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 08:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 08:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 08:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 08:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 08:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 08:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 09:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 09:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 09:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 10:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 10:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 10:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 10:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 10:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 10:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 10:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 10:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 10:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 10:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 10:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 10:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 11:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 11:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 11:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 12:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 12:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 12:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 13:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 13:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 13:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 13:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 13:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 13:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 13:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 13:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 13:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 13:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 13:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 13:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 13:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 13:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 13:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 13:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 13:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 13:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 13:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 13:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 13:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 14:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 14:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 14:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 14:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 14:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 14:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 14:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 14:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 14:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 15:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 15:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 15:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 16:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 16:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 16:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 16:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 16:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 16:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 16:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 16:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 16:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 16:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 16:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 16:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 17:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 17:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 17:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 17:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 17:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 17:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 17:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 17:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 17:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 17:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 17:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 17:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 17:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 17:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 17:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 18:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 18:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 18:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 18:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 18:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 18:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 18:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 18:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 18:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 18:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 18:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 18:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 18:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 18:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 18:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 19:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 19:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 19:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 19:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 19:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 19:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 19:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 19:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 19:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 19:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 19:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 19:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 19:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 19:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 19:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 20:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 20:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 20:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 20:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 20:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 20:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 20:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 20:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 20:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 20:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 20:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 20:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 20:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 20:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 20:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 20:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 20:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 20:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 20:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 20:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 20:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 20:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 20:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 20:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 20:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 20:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 20:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288367, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-05-27 21:01:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 21:01:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 21:01:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 21:01:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 21:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 21:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 21:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 21:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 21:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 21:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 21:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 21:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 22:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 22:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 22:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 22:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 22:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 22:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 22:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 22:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 22:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 22:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 22:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 22:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 22:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 22:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 22:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 23:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 23:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 23:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 23:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 23:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 23:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 23:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 23:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 23:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 23:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 23:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 23:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-27 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-27 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-27 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288470, 'Database Backup [database_backup_2025-05-28-00-00-07-v3-1-6.zip]', '2025-05-28 00:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 00:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 00:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 00:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 00:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 00:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 00:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 00:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 00:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 00:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 00:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 00:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 00:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 01:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 01:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 01:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 01:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 01:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 01:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 01:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 01:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 01:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 02:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 02:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 02:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 02:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 02:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 02:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 02:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 02:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 02:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 02:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 02:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 02:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 02:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 02:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 02:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 03:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 03:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 03:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 03:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 03:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 03:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 03:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 03:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 03:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 03:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 03:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 03:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 03:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 03:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 03:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 04:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 04:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 04:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 04:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 04:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 04:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 04:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 04:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 04:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 04:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 04:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 04:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 05:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 05:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 05:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 05:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 05:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 05:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 05:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 05:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 05:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 05:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 05:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 05:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 06:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 06:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 06:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 06:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 06:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 06:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 06:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 06:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 06:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 06:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 06:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 06:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 06:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 06:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 06:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 06:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 06:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 06:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 06:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 06:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 06:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 07:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 07:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 07:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 07:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 07:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 07:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 07:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 07:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 07:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 07:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 07:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 07:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 07:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 07:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 07:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 08:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 08:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 08:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 08:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 08:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 09:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 09:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 09:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 09:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 09:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 09:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 09:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 09:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 09:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 09:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 09:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 09:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 09:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 09:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 09:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 09:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 09:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 09:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 10:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 10:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 10:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 10:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 10:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 10:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 10:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 10:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 10:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 10:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 10:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 10:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 10:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 10:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 10:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 11:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 11:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 11:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 11:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 11:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 11:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 12:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 12:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 12:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 13:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 13:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 13:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 13:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 13:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 13:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 13:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 13:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 13:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 13:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 13:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 13:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 14:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 14:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 14:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 15:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 15:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 15:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 15:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 15:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 15:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 15:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 15:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 15:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 16:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 16:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 16:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 16:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 16:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 16:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 17:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 17:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 17:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 17:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 17:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 17:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 17:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 17:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 17:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 18:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 18:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 18:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 18:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 18:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 18:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 18:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 18:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 18:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 18:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 18:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 18:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 18:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 18:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 18:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 19:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 19:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 19:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 19:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 19:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 19:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 19:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 19:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 19:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 19:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 19:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 19:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 19:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 19:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 19:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 20:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 20:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 20:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 20:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 20:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 20:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 20:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 20:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 20:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 20:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 20:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 20:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 20:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 20:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289170, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-05-28 21:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289171, 'Email Sent To [Email: projenbeauty@yahoo.com, Template: Invoice Overdue Notice]', '2025-05-28 21:00:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289172, 'Email Sent To [Email: rabiansutherland@gmail.com, Template: Invoice Overdue Notice]', '2025-05-28 21:00:23', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 21:00:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 21:00:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 21:00:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 21:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 21:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 21:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 21:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 21:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 21:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 21:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 21:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 21:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 21:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 21:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 21:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 22:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 22:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 22:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 22:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 22:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 22:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 22:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 22:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 22:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 23:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 23:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 23:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 23:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 23:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 23:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 23:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 23:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 23:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 23:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 23:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 23:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 23:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 23:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 23:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-28 23:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-28 23:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-28 23:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289275, 'Database Backup [database_backup_2025-05-29-00-00-03-v3-1-6.zip]', '2025-05-29 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 00:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 00:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 00:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 00:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 00:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 00:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 00:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 00:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 00:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 00:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 00:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 00:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 00:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 00:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 00:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 01:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 01:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 01:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 01:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 01:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 01:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 01:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 01:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 01:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 02:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 02:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 02:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 02:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 02:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 02:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 02:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 02:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 02:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 02:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 02:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 02:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 02:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 02:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 02:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 02:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 02:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 02:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 03:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 03:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 03:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 03:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 03:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 03:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 03:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 03:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 03:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 03:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 03:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 03:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 03:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 03:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 03:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 04:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 04:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 04:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 04:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 04:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 04:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 05:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 05:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 05:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 05:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 05:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 05:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 05:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 05:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 05:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 06:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 06:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 06:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 06:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 06:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 06:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 06:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 06:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 06:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 06:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 06:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 06:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 06:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 06:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 06:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 07:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 07:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 07:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 07:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 07:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 07:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 07:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 07:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 07:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 08:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 08:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 08:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 09:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 09:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 09:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 12:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 12:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 12:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 13:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 13:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 13:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 13:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 13:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 13:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 14:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 14:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 14:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 14:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 14:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 14:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 14:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 14:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 14:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 15:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 15:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 15:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 15:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 15:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 15:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 16:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 16:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 16:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 17:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 17:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 17:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 17:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 17:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 17:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 17:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 17:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 17:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 17:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 17:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 17:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 18:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 18:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 18:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 18:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 18:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 18:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 18:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 18:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 18:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 18:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 18:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 18:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 19:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 19:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 19:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 19:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 19:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 19:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 19:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 19:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 19:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 19:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 19:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 19:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 20:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 20:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 20:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 20:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 20:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 20:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 20:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 20:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 20:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 20:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 20:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 20:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289969, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-05-29 21:01:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 21:01:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 21:01:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 21:01:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 21:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 21:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 21:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 23:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 23:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 23:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-29 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-29 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-29 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290072, 'Database Backup [database_backup_2025-05-30-00-01-04-v3-1-6.zip]', '2025-05-30 00:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 00:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 00:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 00:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 00:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 00:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 00:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 00:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 00:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 00:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 00:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 00:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 00:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 00:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 00:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 00:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 01:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 01:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 01:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 01:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 01:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 01:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 02:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 02:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 02:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 02:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 02:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 02:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 03:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 03:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 03:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 04:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 04:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 04:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 04:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 04:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 04:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 05:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 05:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 05:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 05:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 05:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 05:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 05:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 05:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 05:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 05:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 05:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 05:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 06:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 06:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 06:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 06:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 06:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 06:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 06:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 06:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 06:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 09:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 09:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 09:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 09:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 09:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 09:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 09:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 09:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 09:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 09:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 09:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 09:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 10:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 10:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 10:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 11:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 11:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 11:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 11:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 11:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 11:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 12:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 12:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 12:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 12:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 12:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 12:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 13:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 13:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 13:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 14:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 14:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 14:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 15:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 15:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 15:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 16:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 16:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 16:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 16:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 16:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 16:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 16:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 16:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 16:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (