<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Preview\TrustedComms;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
abstract class CpsOptions {
    /**
     * @param string $xXcnamSensitivePhoneNumber Phone number to retrieve CPS.
     * @return FetchCpsOptions Options builder
     */
    public static function fetch(string $xXcnamSensitivePhoneNumber = Values::NONE): FetchCpsOptions {
        return new FetchCpsOptions($xXcnamSensitivePhoneNumber);
    }
}

class FetchCpsOptions extends Options {
    /**
     * @param string $xXcnamSensitivePhoneNumber Phone number to retrieve CPS.
     */
    public function __construct(string $xXcnamSensitivePhoneNumber = Values::NONE) {
        $this->options['xXcnamSensitivePhoneNumber'] = $xXcnamSensitivePhoneNumber;
    }

    /**
     * Phone number used to retrieve its corresponding CPS.
     *
     * @param string $xXcnamSensitivePhoneNumber Phone number to retrieve CPS.
     * @return $this Fluent Builder
     */
    public function setXXcnamSensitivePhoneNumber(string $xXcnamSensitivePhoneNumber): self {
        $this->options['xXcnamSensitivePhoneNumber'] = $xXcnamSensitivePhoneNumber;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Preview.TrustedComms.FetchCpsOptions ' . $options . ']';
    }
}