<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="clearfix"></div>
                        <hr class="hr-panel-heading" />
                        <div class="clearfix"></div>
                        
                        <div class="alert alert-info">
                            <i class="fa fa-info-circle"></i>
                            <?php echo _l('manual_recurring_invoices_info'); ?>
                        </div>

                        <table class="table dt-table scroll-responsive" data-order-col="0" data-order-type="desc">
                            <thead>
                                <tr>
                                    <th><?php echo _l('invoice_number'); ?></th>
                                    <th><?php echo _l('invoice_dt_table_heading_client'); ?></th>
                                    <th><?php echo _l('invoice_dt_table_heading_amount'); ?></th>
                                    <th><?php echo _l('invoice_recurring_frequency'); ?></th>
                                    <th><?php echo _l('invoice_recurring_cycles'); ?></th>
                                    <th><?php echo _l('invoice_recurring_last_date'); ?></th>
                                    <th><?php echo _l('invoice_recurring_next_date'); ?></th>
                                    <th><?php echo _l('options'); ?></th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
<script>
    $(function() {
        initDataTable('.table', window.location.href, undefined, undefined, 'undefined', [7, 'desc']);
    });

    function generate_invoice(id) {
        if (confirm('<?php echo _l('manual_recurring_invoices_confirm_generation'); ?>')) {
            window.location.href = admin_url + 'manual_recurring_invoices/generate_invoice/' + id;
        }
    }
</script>