<?php

defined('BASEPATH') or exit('No direct script access allowed');

/*
Module Name: Manual Recurring Invoices
Description: Allows manual generation of recurring invoices before their scheduled date
Version: 1.0.0
Requires at least: 2.3.*
*/

define('MANUAL_RECURRING_INVOICES_MODULE_NAME', 'manual_recurring_invoices');

hooks()->add_action('admin_init', 'manual_recurring_invoices_module_init_menu_items');
hooks()->add_action('admin_init', 'manual_recurring_invoices_permissions');
hooks()->add_action('after_invoice_view_as_client_link', 'manual_recurring_invoices_add_invoice_action');

/**
 * Register activation module hook
 */
register_activation_hook(MANUAL_RECURRING_INVOICES_MODULE_NAME, 'manual_recurring_invoices_activation_hook');

function manual_recurring_invoices_activation_hook()
{
    $CI = &get_instance();
    require_once(__DIR__ . '/install.php');
}

/**
 * Register language files
 */
register_language_files(MANUAL_RECURRING_INVOICES_MODULE_NAME, [MANUAL_RECURRING_INVOICES_MODULE_NAME]);

/**
 * Init module menu items
 */
function manual_recurring_invoices_module_init_menu_items()
{
    $CI = &get_instance();

    if (staff_can('view', 'invoices')) {
        $CI->app_menu->add_sidebar_children_item('sales', [
            'slug'     => 'manual-recurring-invoices',
            'name'     => _l('recurring_invoices_menu'),
            'href'     => admin_url('manual_recurring_invoices'),
            'position' => 35,
        ]);
    }
}

/**
 * Register module permissions
 */
function manual_recurring_invoices_permissions()
{
    $capabilities = [];

    $capabilities['capabilities'] = [
        'view'     => _l('permission_view'),
        'generate' => _l('manual_recurring_invoices_permission_generate'),
    ];

    register_staff_capabilities('manual_recurring_invoices', $capabilities, _l('manual_recurring_invoices'));
}

/**
 * Add generate invoice action to invoice more dropdown
 */
function manual_recurring_invoices_add_invoice_action($invoice)
{
    // Only show for recurring invoices
    if ($invoice->recurring == 0) {
        return;
    }

    // Don't show if cycles are completed
    if ($invoice->cycles > 0 && $invoice->cycles == $invoice->total_cycles) {
        return;
    }

    // Check permissions
    if (staff_cant('create', 'invoices')) {
        return;
    }

    echo '<a href="' . admin_url('manual_recurring_invoices/generate_invoice/' . $invoice->id) . '" onclick="return confirm(\'' . _l('manual_recurring_invoices_confirm_generation') . '\');">';
    echo '<i class="fa fa-refresh"></i> ' . _l('manual_recurring_invoices_generate_next_short');
    echo '</a>';
}