#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=330857 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 04:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 04:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 04:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305160, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 04:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 04:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 04:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 04:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305164, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 04:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 04:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 04:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 04:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305168, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 04:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305172, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 04:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 04:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 04:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 04:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305176, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 04:29:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 04:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 04:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 04:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305180, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 04:35:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305184, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 04:41:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305188, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 04:47:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 04:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 04:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 04:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305192, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 04:52:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 04:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 04:58:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 04:58:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305196, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 04:58:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 05:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 05:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 05:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305200, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 05:04:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 05:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 05:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 05:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305204, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 05:10:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 05:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 05:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 05:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305208, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 05:15:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 05:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 05:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 05:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305212, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 05:21:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 05:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 05:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 05:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305216, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 05:26:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 05:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 05:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 05:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305220, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 05:32:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 05:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 05:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 05:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305224, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 05:38:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 05:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 05:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 05:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305228, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 05:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 05:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 05:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 05:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305232, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 05:50:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 05:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 05:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 05:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305236, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 05:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 06:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 06:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 06:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305240, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 06:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 06:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 06:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 06:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305244, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 06:08:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 06:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 06:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 06:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305248, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 06:13:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 06:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 06:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 06:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305252, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 06:19:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 06:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 06:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 06:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305256, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 06:25:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 06:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 06:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 06:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305260, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 06:31:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305264, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 06:37:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 06:42:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 06:42:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 06:42:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305268, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 06:42:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 06:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 06:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 06:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305272, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 06:48:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305276, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 06:54:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 06:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 06:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 06:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305280, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 06:59:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 07:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 07:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 07:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305284, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 07:05:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 07:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 07:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 07:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305288, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 07:10:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 07:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 07:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 07:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305292, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 07:15:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 07:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 07:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 07:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305296, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 07:21:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 07:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 07:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 07:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305300, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 07:26:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305301, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:cbfd:e55b:6982:e5ed:f910]', '2025-06-17 07:28:45', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305302, 'Invoice Status Updated [Invoice Number: INV-173/05/2025, From: Overdue To: Paid]', '2025-06-17 07:29:53', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305303, 'Payment Recorded [ID:128, Invoice Number: INV-173/05/2025, Total: $500.00]', '2025-06-17 07:29:53', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 07:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 07:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 07:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305307, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 07:32:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 07:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 07:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 07:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305311, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 07:38:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 07:44:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 07:44:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 07:44:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305315, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 07:44:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 07:50:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 07:50:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 07:50:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305319, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 07:50:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 07:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 07:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 07:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305323, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 07:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 08:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 08:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 08:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305327, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 08:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 08:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 08:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 08:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305331, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 08:07:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 08:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 08:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 08:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305335, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 08:13:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 08:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 08:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 08:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305339, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 08:18:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 08:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 08:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 08:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305343, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 08:24:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305347, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 08:30:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 08:35:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 08:35:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 08:35:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305351, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 08:35:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 08:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 08:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 08:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305355, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 08:41:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 08:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 08:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 08:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305359, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 08:47:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 08:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 08:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 08:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305363, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 08:52:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 08:57:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 08:57:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 08:57:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305367, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 08:57:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 09:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 09:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 09:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305371, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 09:03:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 09:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 09:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 09:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305375, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 09:09:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 09:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 09:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 09:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305379, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 09:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 09:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 09:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 09:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305383, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 09:20:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 09:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 09:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 09:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305387, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 09:26:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 09:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 09:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 09:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305391, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 09:32:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 09:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 09:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 09:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305395, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 09:37:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 09:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 09:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 09:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305399, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 09:43:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 09:49:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 09:49:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 09:49:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305403, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 09:49:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 09:55:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 09:55:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 09:55:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305407, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 09:55:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 10:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 10:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 10:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305411, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 10:00:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 10:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 10:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 10:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305415, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 10:06:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 10:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 10:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 10:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305419, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 10:12:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 10:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 10:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 10:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305423, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 10:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 10:24:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 10:24:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 10:24:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305427, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 10:24:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 10:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 10:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 10:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305431, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 10:30:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 10:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 10:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 10:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305435, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 10:36:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 10:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 10:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 10:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305439, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 10:42:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 10:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 10:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 10:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305443, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 10:48:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 10:54:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 10:54:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 10:54:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305447, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 10:54:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305451, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 11:00:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 11:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 11:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 11:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305455, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 11:06:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305459, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 11:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 11:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 11:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 11:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305463, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 11:17:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305467, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 11:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 11:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 11:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 11:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305471, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 11:28:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 11:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 11:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 11:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305475, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 11:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 11:39:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 11:39:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 11:39:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305479, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 11:39:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 11:44:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 11:44:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 11:44:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305483, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 11:44:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 11:50:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 11:50:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 11:50:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305487, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 11:50:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 11:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 11:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 11:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305491, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 11:56:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 12:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 12:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 12:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305495, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 12:02:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 12:07:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 12:07:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 12:07:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305499, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 12:07:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 12:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 12:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 12:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305503, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 12:13:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 12:19:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 12:19:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 12:19:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305507, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 12:19:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 12:24:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 12:24:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 12:24:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305511, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 12:24:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 12:29:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 12:29:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 12:29:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305515, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 12:29:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 12:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 12:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 12:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305519, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 12:35:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 12:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 12:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 12:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305523, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 12:40:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 12:46:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 12:46:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 12:46:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305527, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 12:46:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 12:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 12:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 12:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305531, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 12:52:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 12:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 12:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 12:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305535, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 12:57:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 13:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 13:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 13:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305539, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 13:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 13:08:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 13:08:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 13:08:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305543, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 13:08:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 13:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 13:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 13:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305547, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 13:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 13:19:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 13:19:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 13:19:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305551, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 13:19:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 13:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 13:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 13:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305555, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 13:25:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 13:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 13:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 13:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305559, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 13:30:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 13:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 13:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 13:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305563, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 13:36:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 13:42:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 13:42:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 13:42:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305567, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 13:42:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 13:48:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 13:48:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 13:48:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305571, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 13:48:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 13:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 13:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 13:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305575, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 13:54:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 14:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 14:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 14:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305579, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 14:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 14:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 14:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 14:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305583, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 14:06:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 14:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 14:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 14:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305587, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 14:12:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 14:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 14:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 14:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305591, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 14:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 14:24:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 14:24:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 14:24:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305595, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 14:24:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 14:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 14:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 14:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305599, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 14:30:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 14:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 14:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 14:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305603, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 14:36:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 14:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 14:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 14:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305607, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 14:42:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 14:48:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 14:48:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 14:48:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305611, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 14:48:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 14:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 14:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 14:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305615, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 14:54:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 15:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 15:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 15:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305619, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 15:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 15:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 15:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 15:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305623, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 15:05:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 15:10:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 15:10:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 15:10:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305627, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 15:10:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 15:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 15:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 15:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305631, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 15:16:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 15:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 15:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 15:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305635, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 15:22:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 15:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 15:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 15:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305639, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 15:28:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 15:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 15:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 15:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305643, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 15:34:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 15:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 15:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 15:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305647, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 15:40:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 15:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 15:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 15:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305651, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 15:46:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 15:51:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 15:51:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 15:51:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305655, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 15:51:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 15:56:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 15:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 15:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305659, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 15:56:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 16:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 16:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 16:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305663, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 16:01:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 16:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 16:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 16:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305667, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 16:07:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 16:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 16:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 16:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305671, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 16:13:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305675, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 16:19:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 16:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 16:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 16:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305679, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 16:24:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 16:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 16:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305683, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 16:30:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 16:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 16:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 16:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305687, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 16:36:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 16:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 16:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 16:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305691, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 16:42:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 16:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 16:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 16:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305695, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 16:48:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 16:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 16:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 16:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305699, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 16:54:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 17:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 17:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 17:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305703, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 17:00:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 17:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 17:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 17:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305707, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 17:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 17:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 17:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 17:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305711, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 17:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 17:17:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 17:17:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 17:17:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305715, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 17:17:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 17:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 17:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 17:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305719, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 17:22:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 17:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 17:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 17:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305723, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 17:28:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 17:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 17:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 17:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305727, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 17:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 17:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 17:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 17:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305731, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 17:40:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 17:46:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 17:46:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 17:46:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305735, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 17:46:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305739, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 17:52:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 17:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 17:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 17:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305743, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 17:57:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 18:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 18:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 18:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305747, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 18:03:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 18:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 18:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 18:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305751, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 18:09:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 18:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 18:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 18:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305755, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 18:14:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 18:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 18:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 18:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305759, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 18:20:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 18:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 18:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 18:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305763, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 18:25:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 18:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 18:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 18:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305767, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 18:31:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 18:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 18:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 18:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305771, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 18:36:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 18:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 18:42:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 18:42:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305775, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 18:42:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 18:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 18:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 18:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305779, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 18:48:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 18:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 18:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 18:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305783, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 18:54:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 19:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 19:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 19:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305787, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 19:00:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 19:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 19:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 19:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305791, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 19:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 19:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 19:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 19:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305795, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 19:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 19:18:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 19:18:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 19:18:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305799, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 19:18:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 19:23:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 19:23:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 19:23:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305803, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 19:23:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 19:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 19:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 19:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305807, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 19:29:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 19:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 19:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 19:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305811, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 19:35:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 19:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 19:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 19:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305815, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 19:40:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 19:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 19:46:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 19:46:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305819, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 19:46:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 19:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 19:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 19:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305823, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 19:52:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 19:58:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 19:58:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 19:58:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305827, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 19:58:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 20:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 20:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 20:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305831, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 20:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 20:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 20:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 20:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305835, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 20:09:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 20:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 20:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 20:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305839, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 20:15:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 20:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 20:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 20:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305843, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 20:20:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 20:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 20:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 20:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305847, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 20:26:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 20:31:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 20:31:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 20:31:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305851, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 20:31:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 20:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 20:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 20:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305855, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 20:37:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 20:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 20:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 20:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305859, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 20:43:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 20:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 20:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 20:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305863, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 20:48:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 20:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 20:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 20:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305867, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 20:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 20:59:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 20:59:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 20:59:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305871, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 20:59:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 21:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 21:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 21:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305875, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 21:05:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 21:10:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 21:10:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 21:10:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305879, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 21:10:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 21:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 21:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 21:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305883, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 21:16:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 21:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 21:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 21:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305887, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 21:22:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 21:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 21:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 21:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305891, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 21:28:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 21:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 21:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 21:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305895, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 21:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 21:39:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 21:39:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 21:39:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305899, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 21:39:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 21:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 21:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 21:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305903, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 21:45:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 21:50:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 21:50:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 21:50:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305907, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 21:50:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 21:55:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 21:55:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 21:55:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305911, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 21:55:23', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 22:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 22:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 22:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305915, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 22:01:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 22:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 22:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 22:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305919, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 22:07:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 22:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 22:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 22:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305923, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 22:13:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 22:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 22:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 22:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305927, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 22:19:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 22:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 22:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 22:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305931, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 22:25:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 22:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 22:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 22:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305935, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 22:30:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 22:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 22:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 22:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305939, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 22:36:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 22:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 22:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 22:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305943, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 22:42:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 22:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 22:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 22:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305947, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 22:48:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 22:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 22:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 22:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305951, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 22:53:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 22:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 22:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 22:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305955, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 22:59:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 23:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 23:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 23:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305959, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 23:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 23:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 23:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 23:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305963, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 23:10:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 23:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 23:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 23:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305967, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 23:16:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 23:21:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 23:21:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 23:21:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305971, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 23:21:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 23:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 23:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 23:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305975, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 23:27:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 23:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 23:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 23:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305979, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 23:33:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 23:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 23:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 23:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305983, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 23:38:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 23:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 23:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 23:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305987, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 23:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 23:49:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 23:49:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 23:49:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305991, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 23:49:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 23:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 23:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 23:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305995, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 23:55:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 00:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 00:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 00:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305999, 'Database Backup [database_backup_2025-06-18-00-00-16-v3-1-6.zip]', '2025-06-18 00:00:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306000, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 00:00:21', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 00:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 00:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 00:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306004, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 00:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 00:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 00:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 00:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306008, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 00:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 00:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 00:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 00:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306012, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 00:17:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 00:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 00:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 00:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306016, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 00:23:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 00:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 00:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 00:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306020, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 00:29:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 00:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 00:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 00:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306024, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 00:35:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 00:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 00:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 00:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306028, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 00:40:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 00:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 00:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 00:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306032, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 00:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 00:51:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 00:51:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 00:51:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306036, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 00:51:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 00:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 00:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 00:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306040, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 00:57:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 01:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 01:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 01:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306044, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 01:02:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 01:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 01:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 01:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306048, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 01:08:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 01:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 01:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 01:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306052, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 01:13:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 01:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 01:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 01:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306056, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 01:19:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 01:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 01:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 01:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306060, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 01:25:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 01:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 01:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 01:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306064, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 01:30:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 01:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 01:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 01:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306068, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 01:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 01:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 01:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 01:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306072, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 01:42:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 01:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 01:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 01:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306076, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 01:48:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 01:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 01:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 01:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306080, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 01:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 02:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 02:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 02:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306084, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 02:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 02:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 02:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 02:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306088, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 02:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306092, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 02:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 02:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 02:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 02:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306096, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 02:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 02:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 02:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 02:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306100, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 02:24:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306104, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 02:30:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 02:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 02:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 02:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306108, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 02:36:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306112, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 02:42:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 02:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 02:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 02:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306116, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 02:47:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 02:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 02:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 02:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306120, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 02:53:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 02:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 02:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 02:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306124, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 02:59:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 03:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 03:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 03:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306128, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 03:05:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306132, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 03:11:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 03:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 03:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 03:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306136, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 03:17:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 03:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 03:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 03:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306140, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 03:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 03:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 03:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 03:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306144, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 03:28:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 03:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 03:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 03:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306148, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 03:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 03:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 03:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 03:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306152, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 03:40:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 03:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 03:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 03:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306156, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 03:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306160, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 03:52:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306164, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 03:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 04:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 04:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 04:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306168, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 04:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 04:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 04:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 04:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306172, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 04:10:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 04:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 04:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 04:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306176, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 04:16:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 04:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 04:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 04:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306180, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 04:22:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 04:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 04:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 04:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306184, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 04:28:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 04:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 04:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 04:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306188, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 04:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306192, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 04:40:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 04:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 04:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 04:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306196, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 04:45:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 04:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 04:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 04:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306200, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 04:51:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 04:56:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 04:56:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 04:56:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306204, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 04:56:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 05:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 05:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 05:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306208, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 05:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306212, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 05:08:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 05:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 05:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 05:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306216, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 05:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 05:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 05:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 05:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306220, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 05:20:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 05:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 05:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 05:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306224, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 05:26:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 05:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 05:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 05:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306228, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 05:32:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 05:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 05:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 05:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306232, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 05:37:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306236, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 05:43:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 05:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 05:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 05:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306240, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 05:49:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 05:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 05:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 05:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306244, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 05:55:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 06:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 06:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 06:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306248, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 06:00:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 06:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 06:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 06:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306252, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 06:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 06:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 06:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 06:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306256, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 06:12:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 06:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 06:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 06:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306260, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 06:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 06:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 06:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 06:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306264, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 06:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 06:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 06:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 06:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306268, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 06:29:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 06:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 06:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 06:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306272, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 06:35:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 06:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 06:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 06:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306276, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 06:40:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306280, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 06:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 06:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 06:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 06:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306284, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 06:51:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 06:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 06:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 06:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306288, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 06:57:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 07:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 07:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 07:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306292, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 07:03:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 07:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 07:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 07:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306296, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 07:09:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 07:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 07:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 07:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306300, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 07:15:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 07:21:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 07:21:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 07:21:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306304, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 07:21:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 07:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 07:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 07:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306308, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 07:27:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 07:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 07:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 07:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306312, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 07:33:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306316, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 07:39:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 07:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 07:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 07:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306320, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 07:44:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 07:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 07:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 07:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306324, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 07:50:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 07:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 07:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 07:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306328, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 07:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 08:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 08:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 08:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306332, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 08:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 08:07:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 08:07:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 08:07:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306336, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 08:07:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 08:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 08:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 08:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306340, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 08:13:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 08:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 08:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 08:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306344, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 08:19:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 08:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 08:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 08:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306348, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 08:25:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 08:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 08:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 08:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306352, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 08:30:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 08:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 08:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 08:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306356, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 08:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 08:41:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 08:41:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 08:41:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306360, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 08:41:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 08:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 08:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 08:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306364, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 08:47:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 08:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 08:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 08:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306368, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 08:53:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 08:58:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 08:58:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 08:58:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306372, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 08:58:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 09:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 09:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 09:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306376, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 09:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 09:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 09:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 09:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306380, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 09:10:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306384, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 09:16:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 09:21:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 09:21:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 09:21:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306388, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 09:21:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 09:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 09:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 09:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306392, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 09:27:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 09:33:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 09:33:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 09:33:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306396, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 09:33:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306400, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 09:39:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 09:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 09:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 09:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306404, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 09:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 09:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 09:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 09:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306408, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 09:50:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 09:55:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 09:55:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 09:55:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306412, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 09:55:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 10:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 10:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 10:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306416, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 10:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 10:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 10:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 10:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306420, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 10:06:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 10:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 10:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 10:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306424, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 10:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 10:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 10:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 10:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306428, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 10:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 10:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 10:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 10:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306432, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 10:24:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 10:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 10:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 10:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306436, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 10:30:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 10:35:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 10:35:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 10:35:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306440, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 10:35:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 10:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 10:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 10:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306444, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 10:41:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 10:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 10:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 10:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306448, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 10:47:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306452, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 10:53:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 10:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 10:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 10:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306456, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 10:58:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 11:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 11:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 11:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306460, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 11:03:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 11:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 11:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 11:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306464, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 11:09:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 11:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 11:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 11:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306468, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 11:15:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 11:21:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 11:21:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 11:21:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306472, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 11:21:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 11:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 11:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 11:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306476, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 11:27:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 11:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 11:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 11:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306480, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 11:33:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 11:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 11:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 11:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306484, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 11:39:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 11:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 11:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 11:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306488, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 11:45:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 11:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 11:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 11:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306492, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 11:51:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 11:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 11:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 11:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306496, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 11:57:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 12:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 12:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 12:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306500, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 12:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 12:08:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 12:08:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 12:08:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306504, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 12:08:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 12:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 12:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 12:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306508, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 12:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 12:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 12:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306512, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 12:20:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 12:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 12:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 12:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306516, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 12:25:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 12:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 12:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 12:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306520, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 12:30:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 12:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 12:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 12:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306524, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 12:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 12:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 12:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 12:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306528, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 12:42:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 12:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 12:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 12:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306532, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 12:48:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 12:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 12:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 12:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306536, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 12:53:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 12:59:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 12:59:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 12:59:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306540, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 12:59:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 13:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 13:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 13:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306544, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 13:05:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 13:11:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 13:11:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 13:11:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306548, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 13:11:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 13:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 13:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 13:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306552, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 13:17:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 13:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 13:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 13:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306556, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 13:23:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 13:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 13:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 13:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306560, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 13:28:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306564, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 13:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 13:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 13:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 13:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306568, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 13:39:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 13:44:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 13:44:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 13:44:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306572, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 13:44:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 13:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 13:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 13:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306576, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 13:50:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 13:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 13:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 13:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306580, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 13:56:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 14:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 14:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 14:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306584, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 14:02:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 14:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 14:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 14:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306588, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 14:08:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 14:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 14:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 14:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306592, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 14:13:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 14:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 14:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 14:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306596, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 14:19:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 14:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 14:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 14:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306600, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 14:25:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 14:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 14:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 14:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306604, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 14:31:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 14:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 14:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 14:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306608, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 14:36:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306612, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 14:42:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 14:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 14:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 14:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306616, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 14:47:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 14:52:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 14:52:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 14:52:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306620, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 14:52:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 14:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 14:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 14:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306624, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 14:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 15:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 15:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 15:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306628, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 15:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 15:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 15:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 15:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306632, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 15:09:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 15:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 15:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 15:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306636, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 15:14:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 15:20:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 15:20:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 15:20:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306640, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 15:20:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 15:25:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 15:25:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 15:25:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306644, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 15:25:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 15:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 15:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 15:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306648, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 15:31:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 15:37:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 15:37:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 15:37:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306652, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 15:37:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 15:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 15:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 15:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306656, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 15:43:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 15:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 15:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 15:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306660, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 15:49:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 15:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 15:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 15:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306664, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 15:55:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 16:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 16:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 16:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306668, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 16:01:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 16:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 16:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 16:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306672, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 16:07:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 16:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 16:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 16:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306676, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 16:12:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 16:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 16:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 16:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306680, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 16:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 16:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 16:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 16:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306684, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 16:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 16:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 16:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 16:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306688, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 16:30:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 16:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 16:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 16:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306692, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 16:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 16:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 16:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 16:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306696, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 16:42:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 16:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 16:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 16:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306700, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 16:48:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 16:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 16:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 16:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306704, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 16:54:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306708, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 17:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 17:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 17:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 17:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306712, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 17:06:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 17:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 17:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 17:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306716, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 17:11:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 17:17:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 17:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 17:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306720, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 17:17:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 17:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 17:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 17:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306724, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 17:23:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 17:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 17:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 17:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306728, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 17:29:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 17:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 17:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 17:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306732, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 17:35:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 17:40:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 17:40:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 17:40:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306736, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 17:40:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 17:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 17:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 17:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306740, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 17:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 17:52:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 17:52:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 17:52:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306744, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 17:52:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 17:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 17:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 17:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306748, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 17:58:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 18:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 18:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 18:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306752, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 18:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 18:10:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 18:10:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 18:10:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306756, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 18:10:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 18:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 18:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 18:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306760, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 18:16:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 18:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 18:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 18:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306764, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 18:22:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 18:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 18:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 18:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306768, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 18:28:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 18:34:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 18:34:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 18:34:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306772, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 18:34:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 18:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 18:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 18:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306776, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 18:40:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 18:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 18:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 18:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306780, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 18:45:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306784, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 18:51:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 18:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 18:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 18:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306788, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 18:57:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 19:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 19:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 19:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306792, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 19:03:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306796, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 19:09:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 19:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 19:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 19:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306800, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 19:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 19:19:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 19:19:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 19:19:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306804, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 19:19:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 19:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 19:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 19:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306808, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 19:25:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306812, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 19:31:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306816, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 19:37:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 19:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 19:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 19:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306820, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 19:43:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 19:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 19:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 19:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306824, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 19:48:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 19:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 19:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 19:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306828, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 19:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 20:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 20:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 20:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306832, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 20:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 20:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 20:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 20:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306836, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 20:06:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 20:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 20:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 20:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306840, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 20:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 20:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 20:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 20:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306844, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 20:18:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 20:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 20:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 20:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306848, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 20:24:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 20:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 20:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 20:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306852, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 20:30:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 20:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 20:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 20:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306856, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 20:36:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 20:41:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 20:41:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 20:41:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306860, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 20:41:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 20:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 20:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 20:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306864, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 20:47:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 20:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 20:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 20:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306868, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 20:53:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 20:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 20:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 20:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306872, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 20:59:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306873, 'Invoice Status Updated [Invoice Number: INV-176/06/2025, From: Unpaid To: Overdue]', '2025-06-18 21:05:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 21:05:25', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 21:05:25', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 21:05:25', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306877, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 21:05:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 21:11:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 21:11:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 21:11:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306881, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 21:11:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 21:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 21:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 21:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306885, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 21:17:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 21:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 21:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 21:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306889, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 21:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 21:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 21:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 21:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306893, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 21:29:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 21:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 21:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 21:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306897, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 21:38:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 21:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 21:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 21:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306901, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 21:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 22:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306905, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 22:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 22:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 22:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 22:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306909, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 22:21:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-19 02:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-19 02:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-19 02:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306913, 'Database Backup [database_backup_2025-06-19-02-46-06-v3-1-6.zip]', '2025-06-19 02:46:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306914, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-19 02:46:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-19 10:34:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-19 10:34:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-19 10:34:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306918, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-19 10:34:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-19 12:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-19 12:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-19 12:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306922, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-19 12:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-19 13:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-19 13:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-19 13:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306926, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-19 13:58:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-19 18:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-19 18:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-19 18:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306930, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-19 18:08:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-19 18:19:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-19 18:19:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-19 18:19:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306934, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-19 18:19:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-19 18:52:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-19 18:52:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-19 18:52:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306938, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-19 18:52:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-19 20:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-19 20:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-19 20:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306942, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-19 20:04:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-19 20:55:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-19 20:55:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-19 20:55:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306946, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-19 20:55:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-19 21:38:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-19 21:38:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-19 21:38:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306950, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-19 21:38:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-19 23:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-19 23:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-19 23:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306954, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-19 23:34:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 00:01:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 00:01:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 00:01:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306958, 'Database Backup [database_backup_2025-06-20-00-01-12-v3-1-6.zip]', '2025-06-20 00:01:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306959, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 00:01:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 00:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 00:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 00:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306963, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 00:54:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 02:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 02:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 02:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306967, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 02:20:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 05:40:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 05:40:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 05:40:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306971, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 05:40:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 09:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 09:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 09:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306975, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 09:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 09:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 09:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 09:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306979, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 09:49:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 10:09:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 10:09:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 10:09:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306983, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 10:09:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 10:17:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 10:17:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 10:17:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306987, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 10:17:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 10:24:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 10:24:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 10:24:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306991, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 10:24:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306995, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 10:30:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 10:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 10:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 10:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306999, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 10:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 10:42:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 10:42:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 10:42:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307003, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 10:42:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 10:47:27', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 10:47:27', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 10:47:27', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307007, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 10:47:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 10:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 10:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 10:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307011, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 10:53:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 10:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 10:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 10:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307015, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 10:58:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 11:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 11:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 11:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307019, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 11:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 11:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 11:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 11:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307023, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 11:10:34', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 11:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 11:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 11:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307027, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 11:16:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 11:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 11:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 11:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307031, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 11:22:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 11:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 11:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 11:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307035, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 11:28:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 11:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 11:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 11:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307039, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 11:34:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 11:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 11:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 11:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307043, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 11:40:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 11:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 11:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 11:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307047, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 11:45:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 11:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 11:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 11:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307051, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 11:51:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 11:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 11:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 11:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307055, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 11:57:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 12:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 12:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 12:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307059, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 12:02:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 12:08:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 12:08:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 12:08:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307063, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 12:08:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 12:13:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 12:13:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 12:13:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307067, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 12:13:34', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 12:19:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 12:19:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 12:19:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307071, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 12:19:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 12:25:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 12:25:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 12:25:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307075, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 12:25:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 12:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 12:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 12:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307079, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 12:31:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 12:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 12:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 12:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307083, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 12:37:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 12:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 12:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 12:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307087, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 12:43:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 12:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 12:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 12:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307091, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 12:49:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 12:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 12:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 12:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307095, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 12:54:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 13:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 13:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 13:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307099, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 13:00:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 13:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 13:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 13:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307103, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 13:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 13:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 13:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 13:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307107, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 13:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 13:17:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 13:17:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 13:17:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307111, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 13:17:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 13:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 13:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 13:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307115, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 13:22:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 13:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 13:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 13:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307119, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 13:28:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 13:33:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 13:33:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 13:33:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307123, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 13:33:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 13:39:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 13:39:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 13:39:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307127, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 13:39:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 13:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 13:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 13:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307131, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 13:45:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 13:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 13:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 13:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307135, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 13:50:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 13:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 13:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 13:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307139, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 13:56:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 14:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 14:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 14:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307143, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 14:01:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 14:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 14:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 14:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307147, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 14:07:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 14:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 14:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 14:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307151, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 14:12:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 14:18:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 14:18:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 14:18:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307155, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 14:18:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 14:24:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 14:24:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 14:24:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307159, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 14:24:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 14:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 14:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 14:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307163, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 14:30:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 14:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 14:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 14:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307167, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 14:36:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 14:42:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 14:42:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 14:42:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307171, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 14:42:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 14:47:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 14:47:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 14:47:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307175, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 14:47:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 14:53:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 14:53:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 14:53:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307179, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 14:53:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 14:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 14:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 14:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307183, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 14:59:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 15:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 15:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 15:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307187, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 15:04:34', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 15:10:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 15:10:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 15:10:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307191, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 15:10:36', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 15:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 15:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 15:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307195, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 15:16:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 15:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 15:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 15:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307199, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 15:22:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 15:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 15:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 15:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307203, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 15:28:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 15:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 15:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 15:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307207, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 15:34:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307211, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 15:40:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 15:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 15:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 15:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307215, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 15:45:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 15:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 15:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 15:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307219, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 15:50:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 15:55:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 15:55:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 15:55:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307223, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 15:55:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 16:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 16:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 16:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307227, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 16:01:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 16:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 16:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 16:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307231, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 16:07:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 16:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 16:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 16:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307235, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 16:13:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 16:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 16:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 16:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307239, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 16:19:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 16:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 16:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 16:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307243, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 16:25:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 16:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 16:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 16:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307247, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 16:30:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 16:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 16:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 16:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307251, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 16:36:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 16:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 16:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 16:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307255, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 16:42:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 16:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 16:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 16:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307259, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 16:48:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 16:54:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 16:54:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 16:54:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307263, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 16:54:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 17:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 17:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 17:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307267, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 17:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 17:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 17:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 17:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307271, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 17:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 17:11:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 17:11:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 17:11:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307275, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 17:11:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 17:17:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 17:17:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 17:17:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307279, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 17:17:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 17:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 17:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 17:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307283, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 17:23:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 17:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 17:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 17:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307287, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 17:29:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 17:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 17:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 17:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307291, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 17:35:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 17:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 17:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 17:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307295, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 17:40:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 17:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 17:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 17:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307299, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 17:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 17:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 17:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 17:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307303, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 17:52:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 17:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 17:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 17:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307307, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 17:57:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 18:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 18:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 18:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307311, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 18:03:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307315, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 18:09:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 18:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 18:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 18:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307319, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 18:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 18:19:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 18:19:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 18:19:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307323, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 18:19:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 18:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 18:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 18:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307327, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 18:25:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 18:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 18:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 18:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307331, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 18:30:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307335, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 18:36:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 18:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 18:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 18:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307339, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 18:41:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 18:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 18:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 18:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307343, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 18:47:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 18:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 18:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 18:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307347, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 18:52:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 18:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 18:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 18:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307351, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 18:58:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 19:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 19:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 19:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307355, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 19:03:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 19:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 19:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 19:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307359, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 19:09:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307363, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 19:15:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 19:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 19:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 19:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307367, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 19:20:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 19:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 19:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 19:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307371, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 19:26:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 19:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 19:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 19:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307375, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 19:32:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 19:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 19:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 19:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307379, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 19:37:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 19:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 19:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 19:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307383, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 19:43:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 19:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 19:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 19:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307387, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 19:48:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 19:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 19:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 19:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307391, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 19:54:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 19:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 19:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 19:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307395, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 19:59:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 20:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 20:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 20:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307399, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 20:04:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 20:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 20:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 20:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307403, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 20:10:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307407, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 20:16:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 20:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 20:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 20:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307411, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 20:21:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 20:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 20:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 20:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307415, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 20:27:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 20:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 20:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 20:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307419, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 20:33:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 20:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 20:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 20:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307423, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 20:39:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 20:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 20:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 20:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307427, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 20:45:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 20:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 20:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 20:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307431, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 20:50:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 20:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 20:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 20:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307435, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 20:56:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 21:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 21:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 21:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307439, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 21:01:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 21:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 21:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 21:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307443, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 21:07:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 21:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 21:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 21:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307447, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 21:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 21:18:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 21:18:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 21:18:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307451, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 21:18:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 21:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 21:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 21:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307455, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 21:24:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 21:29:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 21:29:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 21:29:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307459, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 21:29:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 21:35:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 21:35:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 21:35:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307463, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 21:35:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307467, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 21:41:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 21:46:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 21:46:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 21:46:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307471, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 21:46:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 21:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 21:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 21:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307475, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 21:52:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 21:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 21:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 21:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307479, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 21:58:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 22:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 22:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 22:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307483, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 22:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 22:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 22:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 22:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307487, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 22:10:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 22:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 22:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 22:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307491, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 22:16:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 22:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 22:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 22:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307495, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 22:22:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 22:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 22:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 22:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307499, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 22:28:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 22:34:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 22:34:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 22:34:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307503, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 22:34:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 22:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 22:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 22:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307507, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 22:40:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 22:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 22:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 22:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307511, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 22:45:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 22:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 22:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 22:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307515, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 22:51:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 22:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 22:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 22:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307519, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 22:56:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 23:01:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 23:01:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 23:01:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307523, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 23:01:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 23:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 23:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 23:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307527, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 23:07:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 23:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 23:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 23:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307531, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 23:12:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 23:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 23:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 23:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307535, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 23:18:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 23:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 23:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 23:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307539, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 23:24:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 23:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 23:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 23:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307543, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 23:30:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 23:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 23:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 23:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307547, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 23:36:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 23:41:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 23:41:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 23:41:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307551, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 23:41:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307555, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 23:47:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 23:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 23:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 23:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307559, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 23:52:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 23:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 23:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 23:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307563, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 23:58:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 00:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 00:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 00:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307567, 'Database Backup [database_backup_2025-06-21-00-04-07-v3-1-6.zip]', '2025-06-21 00:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307568, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 00:04:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 00:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 00:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 00:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307572, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 00:10:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 00:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 00:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 00:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307576, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 00:16:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 00:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 00:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 00:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307580, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 00:22:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307584, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 00:28:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307588, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 00:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 00:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 00:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 00:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307592, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 00:40:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 00:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 00:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 00:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307596, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 00:46:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 00:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 00:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 00:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307600, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 00:52:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 00:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 00:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 00:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307604, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 00:58:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 01:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 01:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 01:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307608, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 01:04:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 01:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 01:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 01:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307612, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 01:10:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307616, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 01:16:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 01:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 01:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 01:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307620, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 01:21:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 01:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 01:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 01:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307624, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 01:27:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 01:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 01:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 01:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307628, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 01:33:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 01:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 01:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 01:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307632, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 01:38:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 01:43:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 01:43:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 01:43:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307636, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 01:43:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 01:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 01:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 01:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307640, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 01:49:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 01:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 01:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 01:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307644, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 01:54:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 02:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 02:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 02:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307648, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 02:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 02:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 02:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 02:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307652, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 02:05:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 02:11:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 02:11:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 02:11:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307656, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 02:11:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 02:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 02:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 02:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307660, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 02:17:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 02:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 02:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 02:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307664, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 02:22:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307668, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 02:28:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 02:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 02:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 02:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307672, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 02:33:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 02:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 02:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 02:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307676, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 02:39:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307680, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 02:45:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 02:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 02:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 02:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307684, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 02:51:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 02:56:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 02:56:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 02:56:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307688, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 02:56:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 03:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 03:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 03:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307692, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 03:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 03:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 03:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 03:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307696, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 03:08:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 03:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 03:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 03:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307700, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 03:14:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 03:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 03:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 03:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307704, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 03:20:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 03:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 03:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 03:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307708, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 03:26:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307712, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 03:32:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307716, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 03:38:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 03:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 03:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 03:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307720, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 03:43:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 03:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 03:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 03:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307724, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 03:49:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 03:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 03:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 03:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307728, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 03:55:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 04:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 04:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 04:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307732, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 04:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 04:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 04:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 04:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307736, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 04:06:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307740, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 04:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 04:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 04:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 04:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307744, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 04:18:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307748, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 04:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 04:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 04:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 04:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307752, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 04:29:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 04:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 04:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 04:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307756, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 04:35:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 04:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 04:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 04:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307760, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 04:40:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 04:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 04:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 04:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307764, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 04:45:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 04:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 04:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 04:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307768, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 04:51:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 04:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 04:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 04:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307772, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 04:57:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 05:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 05:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 05:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307776, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 05:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307780, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 05:08:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 05:13:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 05:13:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 05:13:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307784, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 05:13:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307788, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 05:19:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 05:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 05:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 05:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307792, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 05:24:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 05:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307796, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 05:30:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 05:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 05:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 05:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307800, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 05:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 05:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 05:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 05:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307804, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 05:41:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 05:47:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 05:47:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 05:47:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307808, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 05:47:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 05:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 05:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 05:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307812, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 05:53:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 05:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 05:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 05:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307816, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 05:59:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 06:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 06:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 06:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307820, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 06:05:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 06:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 06:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 06:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307824, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 06:10:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 06:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 06:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 06:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307828, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 06:15:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 06:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 06:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 06:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307832, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 06:21:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307836, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 06:27:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 06:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 06:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 06:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307840, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 06:33:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307844, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 06:39:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 06:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 06:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 06:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307848, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 06:44:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 06:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 06:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 06:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307852, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 06:50:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307856, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 06:56:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 07:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 07:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 07:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307860, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 07:01:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 07:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 07:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 07:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307864, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 07:07:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 07:12:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 07:12:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 07:12:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307868, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 07:12:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 07:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 07:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 07:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307872, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 07:18:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307876, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 07:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 07:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 07:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 07:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307880, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 07:29:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 07:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 07:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 07:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307884, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 07:35:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307888, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 07:41:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 07:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 07:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 07:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307892, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 07:47:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307896, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 07:53:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 07:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 07:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 07:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307900, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 07:59:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 08:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 08:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 08:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307904, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 08:04:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 08:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 08:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 08:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307908, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 08:10:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307912, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 08:16:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307916, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 08:22:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 08:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 08:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 08:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307920, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 08:27:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 08:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 08:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 08:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307924, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 08:33:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 08:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 08:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 08:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307928, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 08:38:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 08:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 08:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 08:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307932, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 08:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 08:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 08:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 08:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307936, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 08:50:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 08:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 08:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 08:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307940, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 08:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 09:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 09:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 09:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307944, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 09:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 09:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 09:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 09:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307948, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 09:08:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 09:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 09:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 09:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307952, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 09:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 09:19:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 09:19:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 09:19:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307956, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 09:19:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 09:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 09:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 09:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307960, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 09:25:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307964, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 09:31:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 09:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 09:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 09:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307968, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 09:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 09:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 09:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307972, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 09:42:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 09:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 09:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 09:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307976, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 09:48:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 09:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 09:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 09:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307980, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 09:54:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307984, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 10:00:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 10:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 10:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 10:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307988, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 10:06:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 10:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 10:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 10:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307992, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 10:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 10:17:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 10:17:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 10:17:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307996, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 10:17:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 10:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 10:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 10:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308000, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 10:23:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 10:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 10:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 10:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308004, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 10:28:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308008, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 10:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308012, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 10:40:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 10:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 10:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 10:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308016, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 10:45:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 10:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 10:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308020, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 10:51:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 10:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 10:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 10:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308024, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 10:56:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 11:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 11:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 11:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308028, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 11:01:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 11:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 11:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 11:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308032, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 11:07:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308036, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 11:13:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 11:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 11:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 11:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308040, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 11:18:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 11:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 11:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 11:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308044, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 11:24:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 11:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 11:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 11:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308048, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 11:30:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 11:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 11:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 11:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308052, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 11:36:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 11:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 11:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 11:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308056, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 11:42:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308060, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 11:48:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308064, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 11:54:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 11:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 11:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 11:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308068, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 11:59:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 12:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 12:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 12:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308072, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 12:05:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308076, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 12:11:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 12:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 12:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 12:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308080, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 12:16:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 12:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 12:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 12:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308084, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 12:22:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 12:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 12:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 12:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308088, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 12:28:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 12:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 12:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 12:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308092, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 12:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 12:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 12:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 12:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308096, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 12:40:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308100, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 12:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 12:51:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 12:51:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 12:51:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308104, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 12:51:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 12:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 12:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 12:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308108, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 12:57:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 13:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 13:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 13:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308112, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 13:03:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 13:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 13:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 13:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308116, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 13:09:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 13:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 13:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 13:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308120, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 13:14:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 13:19:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 13:19:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 13:19:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308124, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 13:19:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 13:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 13:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 13:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308128, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 13:25:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 13:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 13:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 13:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308132, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 13:31:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 13:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 13:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 13:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308136, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 13:37:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 13:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 13:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 13:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308140, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 13:42:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 13:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 13:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 13:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308144, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 13:48:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 13:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 13:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 13:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308148, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 13:54:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 14:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 14:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 14:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308152, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 14:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 14:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 14:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 14:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308156, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 14:06:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 14:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 14:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 14:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308160, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 14:12:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 14:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 14:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 14:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308164, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 14:18:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308168, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 14:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 14:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 14:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 14:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308172, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 14:29:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 14:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 14:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 14:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308176, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 14:34:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 14:39:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 14:39:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 14:39:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308180, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 14:39:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 14:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 14:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 14:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308184, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 14:45:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 14:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 14:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 14:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308188, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 14:50:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 14:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 14:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 14:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308192, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 14:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 15:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 15:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 15:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308196, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 15:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 15:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 15:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 15:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308200, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 15:08:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 15:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 15:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 15:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308204, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 15:13:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 15:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 15:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 15:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308208, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 15:19:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 15:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 15:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 15:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308212, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 15:25:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 15:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 15:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 15:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308216, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 15:31:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 15:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 15:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 15:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308220, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 15:37:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 15:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 15:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 15:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308224, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 15:42:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 15:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 15:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 15:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308228, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 15:48:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 15:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 15:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 15:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308232, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 15:53:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 15:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 15:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 15:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308236, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 15:59:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 16:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 16:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 16:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308240, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 16:04:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308244, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 16:10:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 16:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 16:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 16:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308248, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 16:15:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 16:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 16:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 16:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308252, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 16:21:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 16:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 16:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 16:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308256, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 16:26:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 16:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 16:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 16:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308260, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 16:32:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 16:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 16:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 16:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308264, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 16:38:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 16:43:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 16:43:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 16:43:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308268, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 16:43:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 16:49:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 16:49:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 16:49:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308272, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 16:49:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 16:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 16:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 16:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308276, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 16:55:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 17:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 17:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 17:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308280, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 17:00:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 17:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 17:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 17:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308284, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 17:06:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 17:11:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 17:11:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 17:11:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308288, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 17:11:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 17:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 17:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 17:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308292, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 17:17:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308296, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 17:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 17:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 17:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 17:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308300, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 17:28:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 17:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 17:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 17:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308304, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 17:34:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 17:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 17:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 17:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308308, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 17:40:36', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308312, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 17:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 17:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 17:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 17:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308316, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 17:52:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 17:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 17:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 17:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308320, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 17:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 18:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 18:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 18:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308324, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 18:04:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 18:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 18:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 18:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308328, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 18:10:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 18:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 18:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 18:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308332, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 18:16:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 18:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 18:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 18:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308336, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 18:21:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 18:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 18:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 18:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308340, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 18:27:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 18:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 18:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 18:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308344, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 18:32:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 18:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 18:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 18:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308348, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 18:38:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 18:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 18:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 18:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308352, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 18:44:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 18:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 18:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 18:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308356, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 18:50:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308360, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 18:56:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 19:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 19:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 19:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308364, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 19:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 19:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 19:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 19:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308368, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 19:08:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 19:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 19:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 19:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308372, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 19:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 19:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 19:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 19:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308376, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 19:20:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 19:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 19:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 19:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308380, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 19:26:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 19:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 19:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 19:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308384, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 19:32:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 19:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 19:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 19:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308388, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 19:38:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 19:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 19:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 19:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308392, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 19:44:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 19:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 19:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 19:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308396, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 19:50:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 19:55:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 19:55:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 19:55:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308400, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 19:55:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 20:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 20:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 20:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308404, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 20:00:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 20:06:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 20:06:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 20:06:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308408, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 20:06:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 20:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 20:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 20:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308412, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 20:12:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 20:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 20:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 20:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308416, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 20:18:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 20:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 20:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 20:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308420, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 20:24:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308424, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 20:30:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 20:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 20:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 20:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308428, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 20:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 20:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 20:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 20:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308432, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 20:42:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 20:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 20:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 20:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308436, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 20:48:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 20:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 20:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 20:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308440, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 20:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 21:00:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 21:00:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 21:00:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308444, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 21:00:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 21:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 21:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 21:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308448, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 21:06:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 21:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 21:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 21:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308452, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 21:12:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 21:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 21:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 21:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308456, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 21:18:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 21:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 21:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 21:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308460, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 21:23:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 21:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 21:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 21:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308464, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 21:29:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 21:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 21:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 21:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308468, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 21:35:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 21:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 21:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 21:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308472, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 21:40:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 21:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 21:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 21:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308476, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 21:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 21:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 21:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 21:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308480, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 21:51:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 21:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 21:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 21:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308484, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 21:57:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 22:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 22:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 22:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308488, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 22:03:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 22:08:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 22:08:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 22:08:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308492, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 22:08:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 22:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 22:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 22:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308496, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 22:14:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 22:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 22:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 22:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308500, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 22:20:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 22:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 22:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 22:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308504, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 22:25:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 22:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 22:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 22:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308508, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 22:31:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 22:37:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 22:37:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 22:37:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308512, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 22:37:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 22:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 22:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 22:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308516, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 22:43:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 22:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 22:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 22:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308520, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 22:49:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 22:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 22:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 22:55:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308524, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 22:55:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 23:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 23:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 23:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308528, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 23:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 23:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 23:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 23:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308532, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 23:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 23:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 23:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 23:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308536, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 23:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 23:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 23:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 23:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308540, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 23:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 23:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 23:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 23:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308544, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 23:24:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 23:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 23:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 23:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308548, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 23:29:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 23:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 23:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 23:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308552, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 23:35:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 23:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 23:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 23:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308556, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 23:40:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 23:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 23:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 23:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308560, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 23:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 23:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 23:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 23:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308564, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 23:51:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 23:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 23:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 23:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308568, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 23:57:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308572, 'Database Backup [database_backup_2025-06-22-00-03-05-v3-1-6.zip]', '2025-06-22 00:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308573, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 00:03:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 00:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 00:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 00:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308577, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 00:09:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 00:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 00:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 00:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308581, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 00:14:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 00:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 00:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 00:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308585, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 00:20:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 00:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 00:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 00:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308589, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 00:25:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 00:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 00:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 00:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308593, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 00:31:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 00:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 00:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 00:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308597, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 00:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 00:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 00:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 00:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308601, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 00:42:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 00:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 00:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 00:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308605, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 00:48:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 00:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 00:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 00:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308609, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 00:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 00:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 00:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 00:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308613, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 00:59:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 01:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 01:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 01:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308617, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 01:05:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 01:11:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 01:11:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 01:11:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308621, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 01:11:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 01:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 01:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 01:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308625, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 01:17:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308629, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 01:23:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 01:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 01:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 01:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308633, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 01:28:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 01:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 01:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 01:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308637, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 01:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 01:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 01:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 01:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308641, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 01:40:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 01:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 01:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 01:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308645, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 01:46:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 01:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 01:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 01:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308649, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 01:52:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 01:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 01:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 01:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308653, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 01:58:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 02:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 02:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 02:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308657, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 02:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 02:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 02:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 02:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308661, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 02:10:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 02:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 02:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 02:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308665, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 02:16:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 02:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 02:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 02:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308669, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 02:22:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 02:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 02:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 02:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308673, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 02:28:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308677, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 02:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 02:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 02:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 02:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308681, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 02:40:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 02:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 02:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 02:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308685, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 02:45:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 02:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 02:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 02:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308689, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 02:51:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 02:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 02:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 02:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308693, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 02:57:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 03:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 03:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 03:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308697, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 03:03:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 03:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 03:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 03:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308701, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 03:09:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 03:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 03:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 03:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308705, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 03:15:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 03:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 03:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 03:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308709, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 03:20:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 03:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 03:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 03:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308713, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 03:25:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 03:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 03:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308717, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 03:31:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 03:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 03:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 03:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308721, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 03:36:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 03:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 03:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 03:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308725, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 03:42:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 03:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 03:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 03:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308729, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 03:48:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 03:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 03:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 03:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308733, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 03:53:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 03:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 03:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 03:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308737, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 03:59:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 04:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 04:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 04:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308741, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 04:05:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 04:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 04:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 04:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308745, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 04:11:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308749, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 04:17:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 04:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 04:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 04:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308753, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 04:22:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 04:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 04:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 04:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308757, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 04:28:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 04:34:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 04:34:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 04:34:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308761, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 04:34:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308765, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 04:40:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 04:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 04:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 04:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308769, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 04:45:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 04:50:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 04:50:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 04:50:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308773, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 04:50:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 04:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 04:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 04:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308777, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 04:56:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 05:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 05:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 05:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308781, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 05:01:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 05:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 05:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 05:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308785, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 05:07:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 05:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 05:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 05:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308789, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 05:13:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 05:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 05:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 05:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308793, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 05:19:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 05:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 05:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 05:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308797, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 05:24:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 05:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 05:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 05:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308801, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 05:30:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 05:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 05:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 05:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308805, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 05:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 05:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 05:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 05:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308809, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 05:42:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 05:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 05:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 05:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308813, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 05:48:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 05:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 05:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 05:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308817, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 05:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 06:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 06:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 06:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308821, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 06:00:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 06:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 06:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 06:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308825, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 06:06:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 06:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 06:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 06:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308829, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 06:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 06:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 06:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 06:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308833, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 06:18:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 06:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 06:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 06:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308837, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 06:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 06:29:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 06:29:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 06:29:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308841, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 06:29:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 06:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 06:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 06:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308845, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 06:35:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 06:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 06:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 06:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308849, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 06:40:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 06:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 06:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 06:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308853, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 06:46:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 06:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 06:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 06:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308857, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 06:52:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 06:58:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 06:58:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 06:58:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308861, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 06:58:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 07:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 07:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 07:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308865, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 07:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 07:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 07:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 07:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308869, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 07:10:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 07:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 07:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 07:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308873, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 07:16:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 07:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 07:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 07:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308877, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 07:22:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 07:27:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 07:27:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 07:27:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308881, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 07:27:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 07:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 07:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 07:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308885, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 07:33:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 07:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 07:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 07:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308889, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 07:38:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308893, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 07:44:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 07:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 07:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 07:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308897, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 07:50:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 07:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 07:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 07:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308901, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 07:56:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308905, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 08:02:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 08:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 08:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 08:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308909, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 08:07:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308913, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 08:13:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 08:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 08:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 08:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308917, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 08:19:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 08:24:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 08:24:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 08:24:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308921, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 08:24:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308925, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 08:30:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 08:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 08:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 08:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308929, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 08:36:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 08:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 08:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 08:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308933, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 08:41:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 08:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 08:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 08:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308937, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 08:47:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 08:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 08:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 08:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308941, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 08:52:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308945, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 08:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 09:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 09:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 09:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308949, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 09:03:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 09:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 09:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 09:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308953, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 09:09:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 09:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 09:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 09:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308957, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 09:14:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 09:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 09:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 09:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308961, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 09:20:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 09:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 09:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 09:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308965, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 09:26:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 09:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 09:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 09:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308969, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 09:32:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 09:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 09:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 09:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308973, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 09:38:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308977, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 09:44:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 09:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 09:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 09:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308981, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 09:49:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 09:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 09:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 09:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308985, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 09:55:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308989, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 10:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 10:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 10:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 10:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308993, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 10:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308997, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 10:12:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 10:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 10:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 10:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309001, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 10:18:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309005, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 10:24:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 10:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 10:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 10:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309009, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 10:29:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 10:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 10:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 10:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309013, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 10:35:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 10:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 10:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 10:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309017, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 10:40:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309021, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 10:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 10:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 10:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 10:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309025, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 10:51:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 10:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 10:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 10:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309029, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 10:56:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 11:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 11:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 11:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309033, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 11:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309037, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 11:08:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 11:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 11:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 11:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309041, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 11:13:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 11:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 11:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 11:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309045, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 11:19:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 11:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 11:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 11:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309049, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 11:25:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 11:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 11:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 11:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309053, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 11:30:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 11:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 11:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 11:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309057, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 11:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 11:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 11:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 11:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309061, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 11:42:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 11:47:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 11:47:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 11:47:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309065, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 11:47:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 11:52:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 11:52:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 11:52:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309069, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 11:52:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 11:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 11:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 11:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309073, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 11:58:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 12:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 12:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309077, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 12:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 12:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 12:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 12:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309081, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 12:09:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 12:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 12:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 12:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309085, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 12:15:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 12:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 12:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 12:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309089, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 12:21:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 12:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 12:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 12:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309093, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 12:27:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 12:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 12:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 12:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309097, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 12:32:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 12:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 12:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 12:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309101, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 12:38:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 12:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 12:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 12:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309105, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 12:44:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 12:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 12:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 12:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309109, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 12:50:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 12:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 12:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 12:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309113, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 12:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 13:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 13:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 13:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309117, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 13:02:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 13:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 13:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 13:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309121, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 13:08:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 13:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 13:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 13:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309125, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 13:13:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 13:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 13:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 13:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309129, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 13:19:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 13:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 13:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 13:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309133, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 13:25:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309137, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 13:31:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 13:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 13:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 13:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309141, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 13:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 13:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 13:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 13:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309145, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 13:42:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 13:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 13:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 13:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309149, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 13:48:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 13:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 13:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 13:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309153, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 13:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 14:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 14:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 14:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309157, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 14:00:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 14:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 14:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 14:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309161, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 14:06:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 14:11:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 14:11:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 14:11:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309165, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 14:11:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 14:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 14:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 14:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309169, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 14:17:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 14:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 14:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 14:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309173, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 14:22:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 14:27:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 14:27:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 14:27:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309177, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 14:27:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309181, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 14:33:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 14:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 14:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 14:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309185, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 14:38:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 14:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 14:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 14:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309189, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 14:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 14:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 14:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 14:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309193, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 14:50:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309197, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 14:56:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 15:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 15:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 15:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309201, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 15:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309205, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 15:08:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 15:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 15:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 15:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309209, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 15:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 15:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 15:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 15:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309213, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 15:20:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 15:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 15:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 15:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309217, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 15:26:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 15:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 15:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 15:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309221, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 15:32:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 15:38:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 15:38:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 15:38:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309225, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 15:38:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 15:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 15:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 15:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309229, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 15:44:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 15:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 15:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 15:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309233, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 15:50:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309237, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 15:56:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 16:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 16:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 16:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309241, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 16:01:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 16:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 16:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 16:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309245, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 16:06:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 16:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 16:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 16:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309249, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 16:12:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 16:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 16:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309253, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 16:18:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 16:23:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 16:23:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 16:23:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309257, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 16:23:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 16:29:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 16:29:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 16:29:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309261, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 16:29:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 16:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 16:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 16:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309265, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 16:35:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 16:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 16:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 16:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309269, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 16:40:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 16:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 16:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 16:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309273, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 16:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 16:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 16:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 16:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309277, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 16:52:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 16:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 16:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 16:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309281, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 16:57:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 17:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 17:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 17:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309285, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 17:03:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 17:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 17:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 17:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309289, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 17:09:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 17:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 17:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 17:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309293, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 17:14:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309297, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 17:20:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 17:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 17:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 17:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309301, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 17:25:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 17:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 17:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 17:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309305, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 17:30:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 17:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 17:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 17:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309309, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 17:36:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 17:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 17:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 17:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309313, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 17:41:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309317, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 17:47:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 17:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 17:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 17:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309321, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 17:53:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 17:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 17:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 17:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309325, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 17:59:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 18:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 18:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 18:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309329, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 18:05:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 18:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 18:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 18:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309333, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 18:11:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 18:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 18:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 18:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309337, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 18:17:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 18:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 18:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 18:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309341, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 18:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 18:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 18:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 18:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309345, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 18:29:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 18:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 18:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 18:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309349, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 18:35:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 18:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 18:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 18:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309353, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 18:40:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 18:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 18:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 18:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309357, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 18:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 18:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 18:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 18:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309361, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 18:51:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 18:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 18:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 18:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309365, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 18:57:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 19:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 19:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 19:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309369, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 19:02:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 19:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 19:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 19:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309373, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 19:08:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 19:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 19:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 19:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309377, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 19:14:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 19:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 19:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 19:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309381, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 19:20:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309385, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 19:26:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 19:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 19:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 19:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309389, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 19:31:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 19:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 19:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 19:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309393, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 19:37:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 19:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 19:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 19:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309397, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 19:42:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 19:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 19:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 19:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309401, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 19:48:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 19:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 19:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 19:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309405, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 19:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 20:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 20:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 20:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309409, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 20:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 20:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 20:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 20:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309413, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 20:05:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309417, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 20:11:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 20:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 20:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 20:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309421, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 20:16:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 20:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 20:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 20:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309425, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 20:22:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 20:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 20:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 20:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309429, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 20:28:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 20:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 20:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 20:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309433, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 20:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 20:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 20:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 20:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309437, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 20:40:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 20:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 20:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 20:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309441, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 20:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 20:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 20:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 20:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309445, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 20:52:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 20:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 20:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 20:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309449, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 20:57:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 21:03:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 21:03:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 21:03:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309453, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 21:03:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 21:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 21:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 21:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309457, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 21:09:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 21:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 21:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 21:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309461, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 21:15:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 21:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 21:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 21:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309465, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 21:21:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 21:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 21:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 21:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309469, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 21:27:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 21:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 21:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 21:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309473, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 21:33:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 21:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 21:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 21:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309477, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 21:39:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 21:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 21:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 21:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309481, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 21:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 21:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 21:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 21:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309485, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 21:50:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 21:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 21:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 21:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309489, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 21:56:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 22:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 22:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 22:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309493, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 22:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 22:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 22:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 22:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309497, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 22:07:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 22:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 22:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 22:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309501, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 22:13:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 22:18:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 22:18:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 22:18:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309505, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 22:18:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 22:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 22:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 22:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309509, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 22:24:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 22:30:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 22:30:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 22:30:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309513, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 22:30:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 22:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 22:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 22:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309517, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 22:36:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 22:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 22:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 22:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309521, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 22:42:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 22:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 22:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 22:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309525, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 22:48:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 22:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 22:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 22:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309529, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 22:54:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 22:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 22:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 22:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309533, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 22:59:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 23:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 23:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 23:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309537, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 23:05:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 23:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 23:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 23:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309541, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 23:11:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309545, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 23:17:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 23:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 23:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 23:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309549, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 23:22:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 23:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 23:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 23:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309553, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 23:28:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 23:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 23:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 23:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309557, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 23:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 23:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 23:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 23:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309561, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 23:40:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 23:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 23:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 23:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309565, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 23:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309569, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 23:52:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309573, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 23:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 00:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 00:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 00:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309577, 'Database Backup [database_backup_2025-06-23-00-04-05-v3-1-6.zip]', '2025-06-23 00:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309578, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 00:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 00:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 00:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 00:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309582, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 00:10:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 00:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 00:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 00:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309586, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 00:16:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 00:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 00:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 00:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309590, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 00:22:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 00:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 00:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 00:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309594, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 00:28:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309598, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 00:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 00:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 00:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 00:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309602, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 00:39:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 00:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 00:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 00:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309606, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 00:45:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 00:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 00:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 00:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309610, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 00:51:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 00:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 00:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 00:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309614, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 00:57:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 01:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 01:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 01:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309618, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 01:02:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 01:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 01:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 01:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309622, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 01:08:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 01:13:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 01:13:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 01:13:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309626, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 01:13:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 01:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 01:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 01:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309630, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 01:19:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 01:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 01:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 01:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309634, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 01:25:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 01:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 01:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 01:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309638, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 01:31:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 01:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 01:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 01:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309642, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 01:37:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 01:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 01:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 01:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309646, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 01:42:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 01:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 01:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 01:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309650, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 01:48:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 01:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 01:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 01:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309654, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 01:54:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309658, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 02:00:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 02:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 02:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 02:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309662, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 02:06:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 02:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 02:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 02:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309666, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 02:11:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 02:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 02:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 02:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309670, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 02:17:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309674, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 02:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 02:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 02:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 02:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309678, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 02:28:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309682, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 02:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 02:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 02:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 02:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309686, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 02:40:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 02:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 02:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 02:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309690, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 02:45:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 02:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 02:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 02:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309694, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 02:51:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 02:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 02:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 02:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309698, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 02:57:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 03:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 03:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 03:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309702, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 03:03:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 03:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 03:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 03:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309706, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 03:09:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 03:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 03:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 03:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309710, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 03:15:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 03:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 03:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 03:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309714, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 03:20:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 03:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 03:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 03:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309718, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 03:26:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 03:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 03:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 03:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309722, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 03:31:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 03:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 03:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 03:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309726, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 03:37:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 03:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 03:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 03:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309730, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 03:43:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 03:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 03:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 03:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309734, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 03:48:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 03:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 03:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 03:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309738, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 03:53:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 03:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 03:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 03:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309742, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 03:59:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 04:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 04:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 04:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `sta