#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=288470 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 04:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 04:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 04:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 04:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 04:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 04:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 06:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 06:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 06:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 06:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 06:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 06:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 06:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 06:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 06:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 06:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 06:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 06:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 07:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 07:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 07:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 07:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 07:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 07:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 08:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 08:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 08:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 08:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 08:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 08:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 08:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 08:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 08:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 10:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 10:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 10:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 15:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 15:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 15:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 16:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 16:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 16:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 17:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 17:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 17:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 18:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 18:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 18:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 19:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 19:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 19:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 19:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 19:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 19:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 19:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 19:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 19:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 20:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 20:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 20:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265027, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-04-28 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265028, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-04-28 21:03:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 21:03:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 21:03:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 21:03:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 21:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 21:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 21:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 22:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 22:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 22:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 22:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 22:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 22:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 23:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 23:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 23:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265134, 'Database Backup [database_backup_2025-04-29-00-02-03-v3-1-6.zip]', '2025-04-29 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 00:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 00:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 00:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 00:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 00:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 00:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 00:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 00:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 00:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 01:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 01:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 01:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 02:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 02:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 02:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 03:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 03:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 03:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 04:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 04:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 04:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 04:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 04:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 04:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 04:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 04:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 04:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 07:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 07:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 07:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 08:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 08:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 08:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 10:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 10:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 10:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 10:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 10:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 10:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 12:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 12:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 12:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 12:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 12:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 12:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 14:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 14:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 14:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 15:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 15:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 15:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 16:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 16:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 16:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 16:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 16:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 16:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 18:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 18:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 18:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 18:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 18:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 18:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 18:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 18:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 18:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 19:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 19:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 19:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 19:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 19:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 19:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 20:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 20:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 20:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 20:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 20:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265828, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-04-29 21:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 21:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 21:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 21:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 21:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 21:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 21:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 21:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 21:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 21:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 22:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 22:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 22:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 22:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 22:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 22:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 22:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 22:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 22:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 23:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 23:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 23:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 23:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 23:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 23:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 23:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 23:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 23:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 23:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 23:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 23:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265928, 'Database Backup [database_backup_2025-04-30-00-00-09-v3-1-6.zip]', '2025-04-30 00:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 00:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 00:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 00:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 00:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 00:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 00:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 00:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 01:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 01:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 01:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 01:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 01:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 01:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 01:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 01:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 01:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 02:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 02:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 02:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 02:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 02:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 02:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 02:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 02:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 02:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 04:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 04:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 04:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 04:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 04:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 04:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 07:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 07:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 07:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 09:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 09:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 09:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 09:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 09:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 09:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 09:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 09:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 09:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 09:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 09:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 09:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 10:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 10:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 10:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 13:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 13:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 13:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 13:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 13:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 13:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 13:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 13:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 13:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 13:11:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 13:11:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 13:11:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 13:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 13:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 13:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 13:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 13:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 13:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 14:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 14:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 14:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 14:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 14:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 14:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 15:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 15:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 15:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 16:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 16:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 16:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 17:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 17:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 17:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 17:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 17:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 17:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 17:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 17:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 17:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 18:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 18:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 18:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 18:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 18:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 18:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 18:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 18:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 18:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 19:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 19:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 19:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 19:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 19:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 19:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 20:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 20:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 20:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 21:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 21:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 21:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 21:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 21:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 21:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 22:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 22:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 22:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 23:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 23:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 23:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 23:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 23:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 23:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 00:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 00:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 00:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266727, 'Database Backup [database_backup_2025-05-01-00-05-03-v3-1-6.zip]', '2025-05-01 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 00:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 00:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 00:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 01:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 01:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 01:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 01:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 01:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 01:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 01:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 01:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 01:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 02:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 02:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 02:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 03:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 03:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 03:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 04:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 04:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 04:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 04:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 04:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 04:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 04:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 04:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 04:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 05:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 05:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 05:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 06:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 06:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 06:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 06:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 06:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 06:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 07:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 07:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 07:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 08:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 08:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 08:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 09:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 09:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 09:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 10:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 10:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 10:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 11:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 11:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 11:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 11:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 11:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 11:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 12:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 12:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 12:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 13:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 13:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 13:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 14:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 14:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 14:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 15:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 15:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 15:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 15:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 15:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 15:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 16:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 16:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 16:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 17:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 17:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 17:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 17:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 17:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 17:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 18:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 18:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 18:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 18:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 18:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 18:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 19:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 19:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 19:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 19:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 19:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 19:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 19:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 19:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 19:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 19:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 19:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 19:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 20:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 20:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 20:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 20:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 20:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 20:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 20:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 20:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 20:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 20:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 20:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 20:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 20:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 20:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 20:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267427, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-05-01 21:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267428, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-05-01 21:02:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 21:02:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 21:02:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 21:02:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 21:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 21:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 21:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 21:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 21:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 21:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 21:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 21:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 21:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 21:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 21:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 21:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 21:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 21:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 22:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 22:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 22:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 22:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 22:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 22:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 22:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 22:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 22:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 23:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 23:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 23:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 23:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 23:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 23:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 23:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 23:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 23:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 23:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 23:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 23:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-01 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-01 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-01 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267534, 'Database Backup [database_backup_2025-05-02-00-00-04-v3-1-6.zip]', '2025-05-02 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 01:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 01:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 01:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 01:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 01:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 01:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 01:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 01:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 01:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 03:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 03:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 03:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 03:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 03:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 03:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 04:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 04:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 04:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 04:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 04:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 04:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 06:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 06:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 06:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 06:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 06:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 06:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 06:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 06:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 06:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 07:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 07:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 07:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 08:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 08:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 08:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 08:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 08:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 08:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 11:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 11:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 11:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 11:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 11:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 11:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 13:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 13:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 13:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 14:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 14:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 14:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 14:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 14:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 14:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 14:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 14:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 14:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 14:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 14:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 14:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 15:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 15:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 15:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 15:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 15:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 15:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 15:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 15:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 15:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 16:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 16:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 16:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 16:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 16:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 16:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 16:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 16:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 16:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 17:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 17:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 17:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 17:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 17:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 17:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 18:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 18:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 18:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 18:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 18:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 18:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 18:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 18:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 18:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 19:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 19:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 19:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 19:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 19:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 19:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 20:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 20:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 20:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 20:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 20:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 20:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 20:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 20:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 20:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268246, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-05-02 21:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 21:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 21:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 21:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 21:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 21:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 21:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 21:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 21:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 21:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 21:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 21:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 21:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 21:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 21:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 21:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 22:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 22:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 22:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 22:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 22:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 22:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 22:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 22:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 22:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 23:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 23:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 23:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 23:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 23:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 23:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268349, 'Database Backup [database_backup_2025-05-03-00-02-04-v3-1-6.zip]', '2025-05-03 00:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 00:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 00:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 00:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 00:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 00:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 00:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 01:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 01:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 01:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 02:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 02:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 02:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 02:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 02:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 02:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 03:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 03:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 03:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 03:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 03:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 03:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 03:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 03:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 03:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 04:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 04:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 04:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 04:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 04:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 04:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 05:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 05:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 05:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 05:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 05:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 05:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 06:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 06:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 06:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 07:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 07:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 07:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 08:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 08:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 08:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 09:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 09:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 09:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 11:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 11:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 11:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 12:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 12:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 12:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 13:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 13:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 13:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 13:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 13:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 13:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 14:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 14:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 14:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 15:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 15:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 15:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 16:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 16:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 16:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 16:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 16:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 16:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staff