#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=200666 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 05:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 05:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 05:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 07:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 07:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 07:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 09:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 09:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 09:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 10:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 10:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 10:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 12:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 12:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 12:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 14:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 14:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 14:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 19:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176717, 'Database Backup [database_backup_2025-01-10-00-00-03-v3-1-6.zip]', '2025-01-10 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 05:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 05:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 05:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 16:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 16:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 16:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 20:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 20:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 20:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177387, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-01-10 21:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177388, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-01-10 21:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 21:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 21:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 21:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 21:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 21:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 21:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 21:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 21:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 21:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 23:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 23:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 23:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177488, 'Database Backup [database_backup_2025-01-11-00-00-03-v3-1-6.zip]', '2025-01-11 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 08:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 08:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 08:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 15:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 15:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 15:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 18:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 18:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 18:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 19:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 19:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 19:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178185, 'Invoice Status Updated [Invoice Number: INV-166/01/2025, From: Unpaid To: Overdue]', '2025-01-11 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178186, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-01-11 21:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 21:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 21:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 21:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178295, 'Database Backup [database_backup_2025-01-12-00-03-02-v3-1-6.zip]', '2025-01-12 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 01:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 01:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 01:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 05:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 05:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 05:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 12:06:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 12:06:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 12:06:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 16:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 16:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 16:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 17:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 17:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 17:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179088, 'Database Backup [database_backup_2025-01-13-00-03-02-v3-1-6.zip]', '2025-01-13 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 06:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 06:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 06:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 07:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 07:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 07:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 11:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 11:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 11:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 18:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 18:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 18:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179794, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-01-13 21:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179795, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-01-13 21:04:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 21:04:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 21:04:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 21:04:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 23:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 23:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 23:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179895, 'Database Backup [database_backup_2025-01-14-00-00-05-v3-1-6.zip]', '2025-01-14 00:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 00:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 00:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 00:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 02:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 02:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 02:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 03:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 03:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 03:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180208, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-01-14 09:40:38', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 12:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 12:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 12:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180481, 'Fa