#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=255305 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 04:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 04:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 04:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 04:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 04:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 04:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 06:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 06:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 06:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 07:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 07:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 07:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 11:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 11:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 11:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 12:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 12:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 12:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 13:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 13:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 13:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 14:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 14:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 14:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 14:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 14:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 14:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 15:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 15:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 15:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 15:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 17:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 17:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 17:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 18:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 18:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 18:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 18:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 18:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 18:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 19:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 19:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 19:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 20:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 20:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 20:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230510, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-03-17 21:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230511, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-03-17 21:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 21:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 21:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 21:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 21:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 21:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 21:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 21:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 21:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 21:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 22:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 22:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 22:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 22:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 22:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 22:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230617, 'Database Backup [database_backup_2025-03-18-00-03-02-v3-1-6.zip]', '2025-03-18 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 02:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 02:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 02:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 03:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 03:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 03:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 04:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 04:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 04:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 04:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 04:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 04:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 05:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 05:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 05:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 05:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 05:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 05:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 06:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 06:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 06:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 07:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 07:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 07:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 08:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 08:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 08:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 10:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 10:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 10:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 10:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 10:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 10:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 12:11:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 12:11:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 12:11:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 12:11:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 12:11:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 12:11:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 12:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 12:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 12:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 12:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 12:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 12:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 12:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 12:33:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 12:33:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 13:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 13:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 13:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 13:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 13:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 13:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 14:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 14:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 14:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 14:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 14:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 14:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 14:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 14:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 14:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 14:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 15:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 15:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 15:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 16:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 16:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 16:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 16:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 16:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 16:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 18:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 18:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 18:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 18:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 18:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 18:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 20:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 20:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 20:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231353, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-03-18 21:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 21:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 21:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 21:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 21:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 21:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 21:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 22:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 22:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 22:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 22:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 22:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 22:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 23:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 23:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 23:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-18 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-18 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-18 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231456, 'Database Backup [database_backup_2025-03-19-00-02-04-v3-1-6.zip]', '2025-03-19 00:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 02:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 02:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 02:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 02:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 02:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 02:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 03:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 03:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 03:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 03:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 03:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 03:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 04:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 04:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 04:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 04:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 04:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 04:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 04:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 04:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 04:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 04:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 04:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 04:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 05:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 05:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 05:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 06:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 06:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 06:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 06:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 06:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 06:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 06:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 06:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 06:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 07:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 07:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 07:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 08:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 08:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 08:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 09:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 09:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 09:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 10:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 10:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 10:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 11:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 11:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 11:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 12:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 12:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 12:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 12:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 12:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 12:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 12:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 12:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 12:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231949, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:cbfd:16ba:a258:a264:edd8]', '2025-03-19 14:09:31', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 15:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 15:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 15:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (231999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 15:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 17:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 17:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 17:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 17:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 17:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 17:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 18:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 18:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 18:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 19:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 19:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 19:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 19:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 19:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 19:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 20:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 20:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 20:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 20:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 20:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 20:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 21:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 21:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 21:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 21:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 21:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 21:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 21:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 21:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 21:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 22:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 22:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 22:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 23:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 23:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 23:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-19 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-19 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-19 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232292, 'Database Backup [database_backup_2025-03-20-00-02-04-v3-1-6.zip]', '2025-03-20 00:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 01:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 01:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 01:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 02:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 02:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 02:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 04:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 04:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 04:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 04:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 04:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 04:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 06:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 06:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 06:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 09:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 09:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 09:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 10:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 10:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 10:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 10:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 10:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 10:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 13:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 13:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 13:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 13:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 13:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 14:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 14:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 14:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 14:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 14:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 14:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 14:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 14:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 14:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 15:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 15:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 15:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 15:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 15:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 15:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 15:47:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 15:47:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 15:47:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 15:47:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 15:47:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 15:47:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 17:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 17:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 17:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 17:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 17:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 17:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 17:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 17:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 17:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 18:01:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 18:01:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 18:01:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 18:01:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 18:01:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 18:01:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 20:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 20:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 20:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233022, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-03-20 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233023, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-03-20 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233024, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-03-20 21:04:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 21:04:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 21:04:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 21:04:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233028, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-03-20 21:04:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 21:04:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 21:04:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 21:04:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 23:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 23:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 23:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233137, 'Database Backup [database_backup_2025-03-21-00-04-03-v3-1-6.zip]', '2025-03-21 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 01:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 01:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 01:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 01:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 01:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 01:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 03:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 03:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 03:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 07:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 07:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 07:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 07:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 07:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 07:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 08:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 08:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 08:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 08:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 08:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 08:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 09:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 09:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 09:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 10:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 10:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 10:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 10:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 10:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 10:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 10:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 10:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 10:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 11:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 11:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 11:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 14:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 14:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 14:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 14:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 14:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 14:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 14:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 14:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 15:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 15:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 15:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 15:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 15:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 15:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 16:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 16:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 16:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 16:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 16:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 16:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 17:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 17:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 17:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 17:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 17:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 17:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 17:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 17:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 17:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 19:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 19:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 19:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 19:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 19:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 19:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 20:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 20:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 20:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 20:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 20:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 20:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 20:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 20:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 20:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233855, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-03-21 21:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 21:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 21:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 21:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 23:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 23:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 23:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 23:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 23:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 23:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233961, 'Database Backup [database_backup_2025-03-22-00-03-03-v3-1-6.zip]', '2025-03-22 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 00:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 00:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 00:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 02:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 02:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 02:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 03:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 03:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 03:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 04:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 04:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 04:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 04:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 04:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 04:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 06:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 06:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 06:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 07:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 07:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 07:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 10:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 10:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 10:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, 