#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=96511 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 05:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 05:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 05:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 07:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 07:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 07:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 10:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 10:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 10:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 11:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 11:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 11:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 12:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 12:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 12:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 12:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 12:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 12:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 12:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 12:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 12:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 14:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 14:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 14:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 17:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 17:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 17:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 20:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 20:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 20:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 22:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 22:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 22:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72922, 'Database Backup [database_backup_2024-09-02-00-04-02-v3-1-6.zip]', '2024-09-02 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 00:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 00:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 00:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 05:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 05:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 05:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 06:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 06:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 06:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 09:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 09:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 09:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 09:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 09:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 09:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 11:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 11:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 11:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 12:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 12:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 12:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 12:28:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 12:28:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 12:28:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 16:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 16:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 16:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 18:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 18:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 18:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 18:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 18:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 18:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 19:11:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 19:11:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 19:11:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 19:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 19:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 19:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73631, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 200.7.90.136]', '2024-09-02 21:07:12', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73638, 'Payment Recorded [ID:114, Invoice Number: INV-121/07/2024, Total: $1,500.00]', '2024-09-02 21:17:47', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 23:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 23:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 23:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 23:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 23:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73738, 'Database Backup [database_backup_2024-09-03-00-04-02-v3-1-6.zip]', '2024-09-03 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 01:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 01:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 01:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 03:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 03:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 03:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 04:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 04:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 04:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 05:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 05:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 05:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 06:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 06:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 06:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 12:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 12:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 12:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 12:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 12:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 12:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 13:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 13:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 13:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 14:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 14:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 14:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 15:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 15:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 15:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74360, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.136]', '2024-09-03 18:24:12', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 20:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 20:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 20:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74445, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-09-03 21:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 21:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 21:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 21:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 22:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 22:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 22:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-03 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-03 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-03 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74554, 'Database Backup [database_backup_2024-09-04-00-03-02-v3-1-6.zip]', '2024-09-04 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 03:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 03:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 03:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 03:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 03:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 03:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 04:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 04:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 04:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 05:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 05:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 05:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 07:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 07:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 07:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 14:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 14:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 14:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 16:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 16:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 16:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 18:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 18:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 18:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 21:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 21:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 21:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 22:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 22:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 22:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75389, 'Database Backup [database_backup_2024-09-05-00-04-03-v3-1-6.zip]', '2024-09-05 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 01:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 01:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 01:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 01:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 01:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 01:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 02:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 02:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 02:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 02:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 02:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 03:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 03:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 03:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 03:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 03:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 03:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 12:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 12:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 12:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 12:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 12:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 12:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 12:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 12:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 14:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 14:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 14:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75933, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.170]', '2024-09-05 16:24:52', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 16:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 16:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 16:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 16:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 16:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 16:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 18:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 18:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 18:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 19:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 19:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 19:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 20:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 20:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 20:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 20:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 20:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 20:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 20:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 20:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 20:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 22:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 22:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 22:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 22:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 23:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 23:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 23:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 23:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 23:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 23:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76210, 'Database Backup [database_backup_2024-09-06-00-05-02-v3-1-6.zip]', '2024-09-06 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 00:11:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 00:11:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 00:11:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 00:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 00:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 00:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 01:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 01:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 01:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 01:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 01:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 01:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 02:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 02:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 02:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 02:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 02:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 02:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 03:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 03:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 03:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 05:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 05:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 05:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 07:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 07:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 07:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 07:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 07:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 07:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 09:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 09:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 09:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 09:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 09:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 09:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 09:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 09:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 09:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 13:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 13:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 13:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 13:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 13:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 13:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76676, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.157]', '2024-09-06 14:21:47', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 14:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 14:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 14:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 15:11:02', '[CRON]');
INSERT INTO