#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=248715 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 05:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 05:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 05:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 05:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 05:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 05:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 11:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 11:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 11:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 12:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 12:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 12:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 13:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 13:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 13:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 14:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 14:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 14:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 15:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 15:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 15:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 16:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 16:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 16:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 17:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 17:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 17:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223991, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-03-09 21:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 21:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 21:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 21:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 21:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 21:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 21:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 21:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 21:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 23:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 23:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 23:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 23:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 23:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 23:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 00:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 00:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 00:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224097, 'Database Backup [database_backup_2025-03-10-00-00-06-v3-1-6.zip]', '2025-03-10 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 00:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 00:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 00:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 02:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 02:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 02:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 03:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 03:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 03:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 03:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 03:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 03:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 04:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 04:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 04:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 04:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 04:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 04:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 05:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 05:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 05:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 06:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 06:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 06:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 08:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 08:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 08:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 14:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 14:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 14:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 16:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 16:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 16:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 16:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 16:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 16:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 19:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 19:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 19:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 20:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 20:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 20:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 21:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 21:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 21:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 21:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 21:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 21:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 22:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224911, 'Database Backup [database_backup_2025-03-11-00-03-03-v3-1-6.zip]', '2025-03-11 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 01:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 01:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 01:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 04:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 04:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 04:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 04:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 04:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 04:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 05:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 05:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 05:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 05:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 09:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 09:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 09:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 14:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 14:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 14:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 16:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 16:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 16:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 17:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 17:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 17:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 18:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 18:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 18:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 19:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 19:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 19:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 19:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 19:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 19:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 20:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 20:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 20:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 20:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 20:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 20:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225626, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-03-11 21:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225627, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-03-11 21:01:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 21:01:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 21:01:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 21:01:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 21:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 21:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 21:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 23:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 23:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 23:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 23:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 23:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 23:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 23:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 23:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 23:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225727, 'Database Backup [database_backup_2025-03-12-00-00-03-v3-1-6.zip]', '2025-03-12 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 01:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 01:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 01:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 02:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 02:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 02:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 04:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 04:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 04:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 06:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 06:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 06:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 06:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 06:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 07:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 07:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 07:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 10:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 10:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 10:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 11:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 11:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 11:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 15:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 15:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 15:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 15:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 15:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 15:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 17:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 17:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 17:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 19:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 19:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 19:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 20:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 20:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 20:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 20:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 20:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 20:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226442, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-03-12 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 21:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 21:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 21:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 23:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 23:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 23:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226551, 'Database Backup [database_backup_2025-03-13-00-03-03-v3-1-6.zip]', '2025-03-13 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 00:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 00:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 00:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 02:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 02:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 02:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 03:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 03:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 03:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 03:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 03:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 03:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 03:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 03:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 03:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 05:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 05:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 05:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 05:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 05:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 05:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 06:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 06:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 06:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 08:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 08:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 08:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 10:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 10:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 10:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 12:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 12:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 12:47:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 12:47:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 12:47:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 12:47:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 14:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 14:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 14:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 14:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 14:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 14:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 16:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 16:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 16:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 16:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 17:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 17:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 17:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 17:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 17:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 17:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 18:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 18:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 18:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 20:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 20:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 20:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 20:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 20:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 20:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 21:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 21:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 21:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 21:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 21:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 21:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 23:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 23:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 23:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227380, 'Database Backup [database_backup_2025-03-14-00-05-03-v3-1-6.zip]', '2025-03-14 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 00:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 00:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 00:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 01:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 01:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 01:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 01:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 01:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 01:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 01:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 01:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 01:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 02:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 02:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 02:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 03:20:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 03:20:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 03:20:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 03:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 03:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 03:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 05:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 05:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 05:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 08:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 08:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 08:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 09:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 09:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 09:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 10:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 10:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 10:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 11:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 11:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 11:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 12:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 12:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 12:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 13:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 13:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 13:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 13:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 13:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 13:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `descrip