#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=135508 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 04:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 04:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 04:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 04:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 04:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 04:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 04:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 04:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 04:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 05:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 05:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 05:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 08:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 08:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 08:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 08:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 08:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 08:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 09:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 09:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 09:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111128, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.174]', '2024-10-19 10:12:01', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111132, 'Client Deleted [ID: 61]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111134, 'Client Deleted [ID: 71]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111135, 'Client Deleted [ID: 82]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111136, 'Client Deleted [ID: 30]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111137, 'Client Deleted [ID: 101]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111138, 'Client Deleted [ID: 75]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111139, 'Client Deleted [ID: 62]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111140, 'Client Deleted [ID: 63]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111142, 'Client Deleted [ID: 27]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111143, 'Client Deleted [ID: 55]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111144, 'Client Deleted [ID: 56]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111145, 'Client Deleted [ID: 57]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111146, 'Client Deleted [ID: 58]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111148, 'Client Deleted [ID: 37]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111150, 'Client Deleted [ID: 43]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111151, 'Client Deleted [ID: 76]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111152, 'Client Deleted [ID: 34]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111154, 'Client Deleted [ID: 72]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111155, 'Client Deleted [ID: 14]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111156, 'Client Deleted [ID: 35]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111157, 'Client Deleted [ID: 26]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111158, 'Client Deleted [ID: 73]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111159, 'Client Deleted [ID: 74]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111160, 'Client Deleted [ID: 32]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111161, 'Client Deleted [ID: 25]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111162, 'Client Deleted [ID: 42]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111163, 'Client Deleted [ID: 53]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111164, 'Client Deleted [ID: 54]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111165, 'Client Deleted [ID: 41]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111166, 'Client Deleted [ID: 33]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111167, 'Client Deleted [ID: 44]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111168, 'Client Deleted [ID: 49]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111170, 'Client Deleted [ID: 24]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 10:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 10:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 10:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 10:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 10:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 10:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 11:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 11:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 11:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 12:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 12:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 12:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 13:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 13:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 13:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 14:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 14:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 14:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 14:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 14:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 14:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 15:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 15:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 15:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 15:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 15:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 15:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 15:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 15:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 15:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 17:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 17:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 17:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 18:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 18:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 18:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 19:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 19:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 19:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 20:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 20:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 20:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 21:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 21:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 21:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 21:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 21:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 21:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 22:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 22:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 22:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 23:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 23:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 23:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 23:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 23:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 23:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111627, 'Database Backup [database_backup_2024-10-20-00-03-02-v3-1-6.zip]', '2024-10-20 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 00:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 00:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 00:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 00:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 00:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 00:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 01:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 01:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 01:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 02:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 02:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 02:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 02:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 02:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 02:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 03:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 03:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 03:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 04:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 04:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 04:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 05:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 05:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 05:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 06:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 06:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 06:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 07:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 07:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 07:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 07:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 07:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 07:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 07:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 07:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 07:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 08:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 08:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 08:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 08:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 08:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 08:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 08:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 08:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 08:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 09:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 09:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 09:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 09:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 09:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 09:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 10:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 10:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 10:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 10:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 10:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 10:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 10:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 10:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 10:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 11:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 11:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 11:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 13:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 13:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 13:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 13:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 13:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 13:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 14:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 14:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 14:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 15:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 15:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 15:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 17:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 17:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 17:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 18:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 18:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 18:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 18:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 18:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 18:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 19:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 19:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 19:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 19:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 19:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 19:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 19:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 19:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 19:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 20:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 20:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 20:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 20:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 20:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 20:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 21:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 21:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 21:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 22:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 22:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 22:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 22:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 22:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 22:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 22:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 22:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 22:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 22:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 22:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 22:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 22:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 22:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 22:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 23:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 23:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 23:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 23:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 23:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 23:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 23:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 23:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 23:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112423, 'Database Backup [database_backup_2024-10-21-00-01-02-v3-1-6.zip]', '2024-10-21 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 02:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 02:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 02:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 03:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 03:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 03:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 03:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 03:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 03:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 04:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 04:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 05:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 05:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 05:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 06:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 06:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 06:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 06:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 06:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 06:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 07:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 07:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 07:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112715, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2024-10-21 08:50:34', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 09:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 09:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 09:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 09:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 09:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 09:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 09:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 09:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 09:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 10:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 10:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 10:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 11:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 11:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 11:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 12:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 12:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 12:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 13:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 13:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 13:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 14:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 14:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 14:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 16:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 16:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 16:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 17:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 17:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 17:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 18:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 18:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 18:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 18:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 18:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 18:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 18:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 18:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 18:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 20:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 20:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 20:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 20:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 20:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 20:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 20:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 20:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 20:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113115, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-10-21 21:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113116, 'Invoice Status Updated [Invoice Number: INV-164/10/2024, From: Unpaid To: Overdue]', '2024-10-21 21:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113117, 'Email Sent To [Email: extreme_effect_graphix@yahoo.com, Template: Invoice Overdue Notice]', '2024-10-21 21:03:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 21:03:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 21:03:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 21:03:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 21:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 21:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 21:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 21:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 21:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 21:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 23:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 23:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 23:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113220, 'Database Backup [database_backup_2024-10-22-00-05-02-v3-1-6.zip]', '2024-10-22 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 00:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 00:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 00:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 00:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 00:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 00:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 01:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 01:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 01:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 02:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 02:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 02:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 05:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 05:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 05:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 06:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 06:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 06:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 06:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 06:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 06:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 06:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 06:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 06:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 06:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 06:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 06:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 08:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 08:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 08:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 10:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 10:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 10:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 12:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 12:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 12:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 12:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 12:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 12:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 13:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 13:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 13:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 14:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 14:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 14:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 16:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 16:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 16:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113797, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.180]', '2024-10-22 17:26:26', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 17:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 17:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 17:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 20:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 20:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 20:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 20:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 20:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 20:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 21:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 21:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 21:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 21:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 21:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 21:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 21:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 21:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 21:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 21:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 21:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 21:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 22:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 22:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 22:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 22:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 22:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 22:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 23:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 23:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 23:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114014, 'Database Backup [database_backup_2024-10-23-00-00-04-v3-1-6.zip]', '2024-10-23 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 00:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 00:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 00:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 01:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 01:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 01:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 01:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 01:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 01:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 02:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 02:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 02:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 02:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 02:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 02:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 03:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 03:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 03:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 03:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 03:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 03:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 04:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 04:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 04:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 05:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 05:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 05:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 06:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 06:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 06:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 06:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 06:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 06:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 06:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 06:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 06:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 07:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 07:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 07:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 07:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 07:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 07:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 08:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 08:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 08:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 09:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 09:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 09:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 09:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 09:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 09:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 11:52:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 11:52:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 11:52:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 12:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 12:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 12:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 14:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 14:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 14:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 15:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 15:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 15:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 21:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 21:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 21:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 21:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 21:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 21:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 21:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 21:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 21:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 22:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 22:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 22:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114813, 'Database Backup [database_backup_2024-10-24-00-05-02-v3-1-6.zip]', '2024-10-24 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 00:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 00:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 00:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 01:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 01:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 01:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 01:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 01:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 01:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 03:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 03:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 03:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114985, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.167]', '2024-10-24 05:15:52', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 05:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 05:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 05:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 05:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 05:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 05:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 05:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 05:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 05:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 05:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 05:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 05:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 06:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 06:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 06:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 09:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 09:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 09:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 10:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 10:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 10:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 11:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 11:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 11:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 11:49:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 11:49:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 11:49:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 14:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 14:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 14:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115377, 'Failed to connect to IMAP auto importing ticket